/*
 * Copyright (c) 1999 Cameron Grant <gandalf@vilnya.demon.co.uk>
 * Copyright (c) 2003 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: emu10kx.h,v 1.44 2005/10/16 10:09:08 chibis Exp $
 * $FreeBSD$
 */

/*
 **********************************************************************
 *     emu10kx.h, nothing here was derived from GPLed 8010.h
*/


#ifndef EMU10KX_H
#define EMU10KX_H

#ifdef _KERNEL

#define EMUPAGESIZE	4096	/* don't change */
#define MAXREQVOICES	8
#define MAXPAGES	(32768 * 64 / EMUPAGESIZE)
/* = WAVEOUT_MAXBUFSIZE * NUM_G / EMUPAGESIZE */
#define RESERVED	0
#define NUM_MIDI	16
#define NUM_G		64	/* use all channels */


#define TMEMSIZE	256*1024
#define TMEMSIZEREG	4

/* XXX */
 /* There is a problem playing sound files less then EMU_DEFAULT_BUFSZ in
  * size. But using large buffer decreases interrupt rate and allow better
  * sound quality on ATA systems... */
#define EMU_DEFAULT_BUFSZ	EMUPAGESIZE*8

/* hw flags */

#define HAS_51		0x0001
#define HAS_71		0x0002
#define HAS_AC97	0x0004

#define IS_EMU10K1	0x0008
#define IS_EMU10K2	0x0010
#define IS_CA0151	0x0020
#define IS_CA0108	0x0040
#define IS_UNKNOWN	0x0080

#define BROKEN_DIGITAL	0x0100
#define DIGITAL_ONLY	0x0200


struct emu_hwinfo {
	uint16_t vendor;
	uint16_t device;
	uint16_t subvendor;
	uint16_t subdevice;
	char SBcode[8];
	char desc[32];
	int flags;
};


struct emu_sc_info;
struct emu_mixer;



/* MIDI device parameters */

struct emu_midiinfo {
	struct emu_sc_info *card;
	int port;
	int portnr;
};
/* PCM device parameters */

struct emu_pcminfo {
	struct emu_sc_info *card;
};
/* SIMPLE IRQ MANAGER INTERFACE */
struct emu_intr_handler {
	void *softc;
	uint32_t intr_mask;
	uint32_t inte_mask;
	         uint32_t(*irq_func) (void *softc, uint32_t irq);
};


#define EMU_MAX_IRQ_CONSUMERS 32
int emu_intr_register(struct emu_sc_info *sc, uint32_t inte_mask, uint32_t intr_mask, uint32_t(*func) (void *softc, uint32_t irq), void *isc);
int emu_intr_unregister(struct emu_sc_info *sc, int ihandle);


struct emu_sc_info {

	/* Hardware and subdevices */
	device_t dev;
	device_t pcm;
	device_t midi[2];
	struct emu_mixer *mixer;
	uint32_t type, rev;

	bus_space_tag_t st;
	bus_space_handle_t sh;
	bus_dma_tag_t parent_dmat;

	/* emu10k device vars */
#if __FreeBSD_version < 500000
	dev_t cdev;
#endif
#if __FreeBSD_version >= 500000
	struct cdev *cdev;
	struct mtx emu10kx_lock;
	struct mtx rw;
#endif
	int emu10kx_isopen;
	struct sbuf emu10kx_sbuf;
	int emu10kx_bufptr;

	/* Resources */
	struct resource *reg, *irq;
	void *ih;
#if __FreeBSD_version >= 500000
	struct mtx lock;
#endif

	/* IRQ handlers */
	struct emu_intr_handler ihandler[EMU_MAX_IRQ_CONSUMERS];

	/* Card HW configuration */
	unsigned int mchannel_fx;
	unsigned int dsp_zero;
	unsigned int code_base;
	unsigned int code_size;
	unsigned int gpr_base;
	unsigned int num_gprs;
	unsigned int input_base;
	unsigned int output_base;
	unsigned int opcode_shift;
	unsigned int high_operand_shift;
	unsigned int address_mask;
	uint32_t is_emu10k1:1, is_emu10k2, is_ca0151:1, is_ca0108:1,
	         has_ac97:1, has_51:1, has_71:1,
		 enable_ir:1, enable_debug:1,
	         broken_digital:1;

	unsigned int num_inputs;
	unsigned int num_outputs;
	unsigned int num_fxbuses;
	unsigned int routing_code_start, routing_code_end;

	/* IRQ Manager */
	uint32_t irq_mask[EMU_MAX_IRQ_CONSUMERS];
	/* Channels gone to -pcm */
	/* buffers and timer */
	unsigned int bufsz;
	int timer, timerinterval;
	/* resource manager */
	struct emu_rm *rm;
};
/* -------------------------------------------------------------------- */

/*
 * prototypes
 */
uint32_t emu_rd(struct emu_sc_info *sc, unsigned int regno, unsigned int size);
void emu_wr(struct emu_sc_info *sc, unsigned int regno, uint32_t data, unsigned int size);

uint32_t emu_rdptr(struct emu_sc_info *sc, unsigned int chn, unsigned int reg);
void emu_wrptr(struct emu_sc_info *sc, unsigned int chn, unsigned int reg, uint32_t data);

uint32_t emu_rd_p16vptr(struct emu_sc_info *sc, uint16_t chn, uint16_t reg);
void emu_wr_p16vptr(struct emu_sc_info *sc, uint16_t chn, uint16_t reg, uint32_t data);


int emu_init(struct emu_sc_info *);
void emu_intr(void *);
int emu_enatimer(struct emu_sc_info *sc, int go);


/* GPLed includes */
#include "alsa/8010.h"
/* BSD license */
#include "emu10kx-fx.h"
#include "emu10kx-opcodes.h"
#include "emu10kx-mixer.h"
#endif				/* _KERNEL */

/* for DSP volume controls */
#define EMU_MAX_INPUT	8
#define EMU_MAX_OUTPUT	16
#define	EMU_MAX_FXBUS	32
#define	EMU_MAX_AMOUNTS	8
#define	EMU_MAX_GPR		512

#endif				/* EMU10K1_H */
