/*
 * Copyright (c) 2003 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: emu10kx-mixer.h,v 1.17 2005/10/09 13:06:47 chibis Exp $
 * $FreeBSD$
 */

#ifndef EMU10KX_MIXER_H
#define EMU10KX_MIXER_H
void emumix_set_mode(struct emu_sc_info *sc, int mode);
void emumix_set_spdif_mode(struct emu_sc_info *sc, int mode);
void emumix_set_fxvol(struct emu_sc_info *sc, unsigned gpr, int32_t vol);
void emumix_set_gpr(struct emu_sc_info *sc, unsigned gpr, int32_t val);


#define MONO	1
#define STEREO	2


#define GPR_P_VOLUME_LEFT	0
#define GPR_P_VOLUME_RIGHT	1
#define	GPR_P_VOLUME	GPR_P_VOLUME_LEFT
#define GPR_R_VOLUME_LEFT	2
#define GPR_R_VOLUME_RIGHT	3
#define	GPR_R_VOLUME	GPR_R_VOLUME_LEFT
#define	GPR_P_CACHE_LEFT	4
#define	GPR_P_CACHE_RIGHT	5
#define	GPR_P_CACHE	GPR_P_CACHE_LEFT
#define	GPR_R_CACHE_LEFT	6
#define	GPR_R_CACHE_RIGHT	7
#define	GPR_R_CACHE	GPR_R_CACHE_LEFT

#define MIXER_P_VOLUME_LEFT	0
#define MIXER_P_VOLUME_RIGHT	1
#define	MIXER_P_VOLUME	MIXER_P_VOLUME_LEFT
#define MIXER_R_VOLUME_LEFT	2
#define MIXER_R_VOLUME_RIGHT	3
#define	MIXER_R_VOLUME	MIXER_R_VOLUME_LEFT

#define NEED_51	0x0001
#define NEED_71	0x0002
#define NEED_AC97	0x0004
#define DEBUG_MIXER	0x0008



struct emu_connector {
	int offset;
	int flags;
	unsigned int channels_used;
	int volume[4];
	int gpr[8];
	char desc[64];
};
#define MIXER_FX        0
#define MIXER_INPUT	1
#define MIXER_OUTPUT 2
#define MIXER_AC97 3
#define MIXER_MAIN 4


struct emu_mixer {
	struct emu_connector *inputs;
	struct emu_connector *outputs;
	struct emu_connector *fxbuses;
	struct emu_connector mix;
	struct emu_connector monomix;
	struct emu_connector amp;
/*	Audigy AC3 passthrough */
	int pt_control;
	int pt_gprs;
	int pt_tgprs;
	int pt_ogprs;

#if 0
	/* FIXME: send_amounts */
	/* for each HW channel */
	int fx_amounts[EMU_MAX_FXBUS][EMU_MAX_AMOUNTS];
	int num_fxbuses;
	int num_fxsends;

	int in_amounts[EMU_MAX_FXBUS][EMU_MAX_AMOUNTS];

#endif
	unsigned int pmixercount[4];
	unsigned int rmixercount[4];
#define MODE_ANALOG	0
#define MODE_DIGITAL	1
	int is_digital:1;
#define SPDIF_MODE_PCM	0
#define SPDIF_MODE_AC3	1
	int spdif_mode:1;
};

int emumix_init(struct emu_sc_info *sc);
void emumix_reset(struct emu_sc_info *sc);
int emumix_uninit(struct emu_sc_info *sc);

#endif
