/*
 * Copyright (c) 2003 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: emu10kx-opcodes.h,v 1.12 2005/09/19 06:53:19 chibis Exp $
 * $FreeBSD$
 */

/*
 **********************************************************************
 *     emu10k1-opcodes.h
*/
#define	MACS	0x0
#define	MACS1	0x1
#define	MACW	0x2
#define	MACW1	0x3
#define	MACINTS	0x4
#define	MACINTW	0x5
#define	ACC3	0x6
#define	MACMV	0x7
#define	ANDXOR	0x8
#define	TSTNEG	0x9
#define	LIMIT	0xA
#define	LIMIT1	0xB
#define	LOG		0xC
#define	EXP		0xD
#define	INTERP	0xE
#define	SKIP	0xF

#define GPR(i)	(sc->gpr_base+(i))
#define INP(i)	(sc->input_base+(i))
#define OUTP(i)	(sc->output_base+(i))
#define FX(i)	(i)
#define DSP_CONST(i) (sc->dsp_zero+(i))

#define COND_NORMALIZED	DSP_CONST(0x1)
#define COND_BORROW		DSP_CONST(0x2)
#define COND_MINUS		DSP_CONST(0x3)
#define COND_LESS_ZERO	DSP_CONST(0x4)
#define COND_EQ_ZERO	DSP_CONST(0x5)
#define COND_SATURATION	DSP_CONST(0x6)
#define COND_NEQ_ZERO	DSP_CONST(0x8)

/* */
/* FX buses */
#define FX_PCM_L			0x00
#define FX_PCM_R			0x01
#define	FX_PCM				FX_PCM_L
#define FX_PCM_LEFT_REAR	0x02
#define FX_PCM_RIGHT_REAR	0x03
#define FX_MIDI_LEFT		0x04
#define FX_MIDI_RIGHT		0x05
#define FX_PCM_CENTER		0x06
#define FX_PCM_LFE			0x07
#define FX_PCM_LEFT_FRONT	0x08
#define FX_PCM_RIGHT_FRONT	0x09
#define FX_MIDI_REVERB		0x0c
#define FX_MIDI_CHORUS		0x0d
#define FX_PT_LEFT			0x14
#define FX_PT_RIGHT			0x15

/* Live! Inputs */
#define IN_AC97_L	 	0x00
#define IN_AC97_R	 	0x01
#define	IN_AC97			IN_AC97_L
#define IN_SPDIF_CD_L	0x02
#define IN_SPDIF_CD_R	0x03
#define IN_SPDIF_CD		IN_SPDIF_CD_L
#define IN_ZOOM_L	 	0x04
#define IN_ZOOM_R	 	0x05
#define IN_ZOOM			IN_ZOOM_L
#define IN_TOSLINK_L	0x06
#define IN_TOSLINK_R	0x07
#define IN_TOSLINK		IN_TOSLINK_L
#define IN_LINE1_L	 	0x08
#define IN_LINE1_R	 	0x09
#define IN_LINE1		IN_LINE1_L
#define IN_COAX_SPDIF_L	0x0a
#define IN_COAX_SPDIF_R	0x0b
#define IN_COAX_SPDIF	IN_COAX_SPDIF_L
#define IN_LINE2_L	 	0x0c
#define IN_LINE2_R	 	0x0d
#define IN_LINE2		IN_LINE2_L
#define IN_0E		 	0x0e
#define IN_0F		 	0x0f

/* Outputs */
#define OUT_AC97_L	 	0x00
#define OUT_AC97_R	 	0x01
#define	OUT_AC97		OUT_AC97_L
#define	OUT_A_FRONT		OUT_AC97
#define OUT_TOSLINK_L 	0x02
#define OUT_TOSLINK_R 	0x03
#define OUT_TOSLINK		OUT_TOSLINK_L
#define OUT_D_CENTER	0x04
#define OUT_D_LFE		0x05
#define OUT_HEADPHONE_L	0x06
#define OUT_HEADPHONE_R	0x07
#define OUT_HEADPHONE	OUT_HEADPHONE_L
#define OUT_REAR_L	 	0x08
#define OUT_REAR_R	 	0x09
#define	OUT_REAR		OUT_REAR_L
#define OUT_ADC_REC_L 	0x0a
#define OUT_ADC_REC_R	0x0b
#define	OUT_ADC_REC		OUT_ADC_REC_L
#define OUT_MIC_CAP		0x0c
#define OUT_A_CENTER	0x11
#define OUT_A_LFE		0x12

/* Audigy Inputs */
#define A_IN_AC97_L		0x00
#define A_IN_AC97_R		0x01
#define A_IN_AC97		A_IN_AC97_L
#define A_IN_SPDIF_CD_L	0x02
#define A_IN_SPDIF_CD_R	0x03
#define	A_IN_SPDIF_CD	A_IN_SPDIF_CD_L
#define A_IN_O_SPDIF_L	0x04
#define A_IN_O_SPDIF_R	0x05
#define	A_IN_O_SPDIF	A_IN_O_SPDIF_L
#define A_IN_LINE2_L	0x08
#define A_IN_LINE2_R	0x09
#define	A_IN_LINE2		A_IN_LINE2_L
#define A_IN_R_SPDIF_L	0x0a
#define A_IN_R_SPDIF_R	0x0b
#define	A_IN_R_SPDIF	A_IN_R_SPDIF_L
#define A_IN_AUX2_L		0x0c
#define A_IN_AUX2_R		0x0d
#define	A_IN_AUX2		A_IN_AUX2_L

/* Audigiy Outputs */
#define A_OUT_D_FRONT_L	0x00
#define A_OUT_D_FRONT_R	0x01
#define	A_OUT_D_FRONT	A_OUT_D_FRONT_L
#define A_OUT_D_CENTER	0x02
#define A_OUT_D_LFE		0x03
#define A_OUT_HPHONE_L	0x04
#define A_OUT_HPHONE_R	0x05
#define A_OUT_HPHONE	A_OUT_HPHONE_L
#define A_OUT_D_REAR_L	0x06
#define A_OUT_D_REAR_R	0x07
#define A_OUT_D_REAR	A_OUT_D_REAR_L
#define A_OUT_A_FRONT_L	0x08
#define A_OUT_A_FRONT_R	0x09
#define	A_OUT_A_FRONT	A_OUT_A_FRONT_L
#define A_OUT_A_CENTER	0x0a
#define A_OUT_A_LFE		0x0b
#define A_OUT_D_SIDE_L	0x0c
#define A_OUT_D_SIDE_R	0x0d
#define A_OUT_D_SIDE	A_OUT_D_SIDE_L
#define A_OUT_A_REAR_L	0x0e
#define A_OUT_A_REAR_R	0x0f
#define A_OUT_A_REAR	A_OUT_A_REAR_L
#define A_OUT_AC97_L	0x10
#define A_OUT_AC97_R	0x11
#define A_OUT_AC97		A_OUT_AC97_L
#define A_OUT_ADC_REC_L	0x16
#define A_OUT_ADC_REC_R	0x17
#define A_OUT_ADC_REC	A_OUT_ADC_REC_L
