/*
 * Copyright (c) 2003 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $id$
 * $FreeBSD$
 */

#ifndef EMU10KX_RM_H
#define EMU10KX_RM_H

#include "emu10kx.h"
#if 0
struct emu_fx_relocable {
#if __FreeBSD_version >= 500000
	struct mtx lock;
#endif
	char desc[64];
	int real_gpr;
};

struct emu_fx_resouce {
#if __FreeBSD_version >= 500000
	struct mtx res_lock;
#endif
	char desc[64];
	signed int gpr_allocmap[EMU_MAX_GPR];
	int length;
	uint32_t *code;
	int relcount;
	struct emu_fx_relocable *rel;
};
#endif
struct emu_rm {
	struct emu_sc_info *card;
#if __FreeBSD_version >= 500000
	struct mtx gpr_lock;
#endif
	signed int allocmap[EMU_MAX_GPR];
	int num_gprs;
	int last_free_gpr;
	int num_used;
};

int emu_rm_init(struct emu_sc_info *sc);
int emu_rm_uninit(struct emu_sc_info *sc);

int emu_rm_gpr_alloc(struct emu_rm *rm, int count);
int emu_rm_gpr_free(struct emu_rm *rm, int gpr, int count);
#endif
