#!/bin/sh -
#
# Copyright (c) 2004  The FreeBSD Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: emuctrl.sh,v 1.2 2005/09/24 12:16:25 chibis Exp $
# Based on src/etc/rc.d/mixer,v 1.5 2005/03/17 22:36:16 njl Exp
#

# PROVIDE: emuctrl
# BEFORE: LOGIN
# KEYWORD: nojail shutdown

. /etc/rc.subr

name="emuctrl"
rcvar=
stop_cmd="emuctrl_stop"
start_cmd="emuctrl_start"
reload_cmd="emuctrl_start"
extra_commands="reload"

#
# List current mixer devices to stdout.
#
list_mixers()
{
	( cd /dev ; ls emu10kx* 2>/dev/null )
}

#
# Save state of an individual mixer specified as $1
#
emuctrl_save()
{
	local dev

	dev="/dev/${1}"
	if [ -r ${dev} ]; then
		${command} -f ${dev} save > /var/db/${1}-state 2>/dev/null
	fi
}

#
# Restore the state of an individual mixer specified as $1
#
emuctrl_restore()
{
	local file dev

	dev="/dev/${1}"
	file="/var/db/${1}-state"
	if [ -r ${dev} -a -r ${file} ]; then
		cat ${file} | xargs -L 1 ${command} -f ${dev}
	fi
}

#
# Restore state of all mixers
#
emuctrl_start()
{
	local mixer

	for mixer in `list_mixers`; do
		emuctrl_restore ${mixer}
	done
}

#
# Save the state of all mixers
#
emuctrl_stop()
{
	local mixer

	for mixer in `list_mixers`; do
		emuctrl_save ${mixer}
	done
}

load_rc_config $name
command=${emuctrl_program:-/usr/local/sbin/emuctrl}
run_rc_command "$1"
