/*
 * engdic.c
 *
 * English dictionary for korean
 *
 * Author: Oh Junseon <hollywar@mail.holywar.net>
 * Date  : $Date: 1999/09/06 02:48:50 $ 
 *
 * $Revision: 1.6 $
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
*/


/* SCSS/RCS Id */
#ifdef LINT
static char rcsid[]="@(#)$Id: engdic.c,v 1.6 1999/09/06 02:48:50 hollywar Exp $";
#endif /* lint */

#if TERMIO
#include <termio.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h> // for get file size //

#include <zlib.h>  // gzip library //

#include "engdic.h"


void error_exit(char *message) ;
int show_result(char *tk , char *tk2) ;
char *lower_string (char *data) ;
int han_check (char *data) ;
void search_hangul (char *key_word) ;
char get_command(void) ;
struct size_buf get_term(void);

char putstr (char *s) ;
char sep[] = ":" ;
static int line = 0 ;

struct size_buf sz ;

int main (int argc , char *argv[]) 
{
    char buf[COLS_MAX] ;
    char command[MAX_LENGTH]  ;
    register char *key_word ;
    register char *small_key_word ;
    register char *tk  , *small_tk;
    char first_char ;
    register int file_size=0 , my_value = 0 , sv=1 , check = 0;

    struct stat sb ;
    
    // type of gzip file //
    register gzFile *gzfp ;
    

    if (argc > 1) {
	key_word = argv[1] ;
    } 

    sz = get_term();
    init() ;

    // start loop //
    while(1) {
	if (argc <= 1) {
	    // get search query //
	    strcpy(command,"");
	    printf("%s",SEARCH_WORD) ;
	    fgets(command,MAX_LENGTH,stdin) ;

	    // remove enter value //
	    command[strlen(command)-1] = '\0' ;
	    key_word = command ;
	}
	// check null line or CTRL + D for terminate program //
	if (!strcmp(key_word,"") || key_word[0] == 4) {
	    printf("%s\r\n",END_WORD) ;
	    break ;
	}
        small_key_word = lower_string(key_word) ;
	
	if (han_check(key_word)) {
	    search_hangul(key_word) ;
	    if (argc > 1) break ; else continue ;
	}

        // get first keyword character for reading file //
        first_char = tolower(key_word[0]) ;
        sprintf(buf,"%s/%c.dic.gz",INSTALL_DIC_DATA_DIR,first_char) ;
    
	// open gzip file //
        // if ( !(gzfp = gzopen(buf,"rb"))) error_exit("File open failed") ;
        if ( !(gzfp = gzopen(buf,"rb"))) continue ;
	if (stat(buf,&sb)==-1) error_exit("File open failed") ;

 	file_size = (int) sb.st_size ;
	my_value = file_size / 2  ;

	
	// Binary search algorism //
	if (strlen(key_word) > 1 && key_word[1] > (int)'c')
	while(1) {
	    gzseek(gzfp,my_value,SEEK_CUR) ;
	    gzgets(gzfp,buf,COLS_MAX) ;
	    gzgets(gzfp,buf,COLS_MAX) ;
	    if (tolower(buf[sv]) > small_key_word[sv] -1) my_value = 0 - abs((my_value/2)) ;
            else if (tolower(buf[sv]) < small_key_word[sv] -1) my_value = abs((my_value/2)) ;
	    else break ;	
	

	    if (my_value == 0) break ;
	}
	if (strlen(key_word) > 1 && key_word[1] > (int)'c' && tolower(buf[sv]) > small_key_word[sv]-1)
	while(1) {
	    gzseek(gzfp,-2000,SEEK_CUR) ;
	    gzgets(gzfp,buf,COLS_MAX) ;
	    gzgets(gzfp,buf,COLS_MAX) ;
	    if (tolower(buf[sv]) > small_key_word[sv] -1) continue ;
	    else break ;
	}
	   
	
	// Matching keyword //
	check=0 ;
        while( (gzgets(gzfp,buf,COLS_MAX))) {
	    tk = strtok(buf,sep) ;
	    small_tk = lower_string(tk) ;

	    // Data have one space (remove one space) //
	    small_tk[strlen(small_tk)-1] = '\0' ;
	
	    if (!strcmp(small_tk,small_key_word)) {
		check=1;
		show_result(tk,strtok(NULL,"\0")) ;
	    }
	    if (check && small_tk[2] > small_key_word[2]) {
	        free(small_tk) ;
	        break ;
	    }
	    free(small_tk) ;
        }

	free(small_key_word) ;

	// close gzip file //
        gzclose(gzfp) ;
	
	putstr("\r\n");
	flush() ;
	line=0 ;
	
	if (argc > 1) break ;
    }
 
    deinit();

    return 0 ;
}


int show_result(char *tk , char *tk2) 
{
    register char *i, *j ;
    register int check_cols_count = 0 ;
    char ch ;
    
    if (tk == NULL || tk2 == NULL) return ;
    
    putstr(WORD_COLOR) ; putstr("[ ") ; putstr(tk); putchr(']') ;
    putstr(NO_COLOR) ; putstr("\r\n") ;
    flush() ;
    line++ ;
    if (line >= sz.height-1) ch = get_command() ;
    
    for (i=++tk2 ; *i != '\0' ; i++ ) {
	if (!check_cols_count) putchr(' ') ;
	check_cols_count ++ ;
	if ( (check_cols_count > sz.width-15 && *i == ' ') || (check_cols_count > sz.width-2) ) {
	    putstr("\r\n");
	    flush() ;
	    line++ ;
	    if (line >= sz.height-1) ch = get_command() ; 
	    check_cols_count=0 ;
	    continue ;
	}
	putchr(*i) ;
    }
    if (check_cols_count != 0) {
	line++ ;
	flush() ;
	if (line >= sz.height-1) ch = get_command() ; 
    }
    
    if (ch == tolower('q')) return 1 ;

    return 0 ;

}

char *lower_string (char *data)
{
   register char *i, *j ;
   register char *code ;

   code = (char *)malloc ((strlen(data)+1) * sizeof (char) );

   for (j=code, i=data; *i!='\0'; i++, j++) {
      if (*i != ' ')
         *j = tolower(*i);
      else *j = ' ' ;
   }
   *j = '\0';

   return code ;
}

int han_check (char *data)
{
    int i=0 ;
	
    for (i=0 ; data[i] != '\0' ; i++) {
        if (data[i] & 0x80) return 1 ;
    }
    return 0 ;
}

void search_hangul (char *key_word)
{
    char buf[COLS_MAX] ;
    register char *tk ;
    int pid_num=0 ;

    register FILE *fp ;

    pid_num = getpid() ;

    sprintf(buf,"zgrep -hw %s %s/*.dic.gz > /tmp/edic.%d",key_word,INSTALL_DIC_DATA_DIR,pid_num);
    system(buf) ;

    sprintf(buf,"/tmp/edic.%d",pid_num) ;

    if ( !(fp = fopen(buf,"rt"))) error_exit("tmp file does not exits");

    while (fgets(buf,COLS_MAX,fp)) {
	tk = strtok(buf,sep) ;
	if (show_result(tk,strtok(NULL,sep))) break ;
    }

    fclose(fp) ;
    sprintf(buf,"rm -f /tmp/edic.%d",pid_num) ;
    system(buf) ;

    putstr("\r\n");
    flush() ;
    line = 0 ;

    return ;

}


void error_exit (char *message)
{
    printf("%s\r\n",message) ;
    exit(1) ;
}

char get_command(void)
{
    char ch ;

    raw_mode(1) ;
    lower_left() ;
    so_enter();
    putstr(GET_COMMAND) ;
    flush() ;
    so_exit();
    ch = getchr();
    lower_left() ;
    clear_eol();
    flush();
    raw_mode(0) ;

    if (ch == '\n') line -- ; else line=0 ;

    return ch ;
}



/*
 | $Id: engdic.c,v 1.6 1999/09/06 02:48:50 hollywar Exp $
 |
 | Local Variables:
 | mode: c
 | mode: font-lock
 | version-control: t
 | delete-old-versions: t
 | End:
 |
 | -*- End-Of-File -*-
 */
