<?php

function xpsave_readconfig(
	$cfg = "/home/et/.etwolf/etpub/xpsave.cfg",
	$sort = "lower_rating")
{

	if(!is_readable($cfg))
		return array();

	$file = file($cfg);
	while(list($lnum,$line) = each($file)) {
		$line = trim($line);
		if($line == "[xpsave]") {
			while(trim($line) != "") {
				list($lnum,$line) = each($file);
				if(trim($line) == "")
					continue;
				$lparts = explode("=", $line);
				if(@count($lparts) < 2) {
					?>
					<!--
					xpsave_readconfig: parse error
					on line <?php echo $lnum;?> near
					<?php echo htmlspecialchars($line);?>
					-->	
					<?php
					continue;
				}
				$p = trim(array_shift($lparts));
				$n = implode("", $lparts); 
				$xpsave[$p] = trim($n);
			}
			// tjw: old versions of xpsave lacked name
			if($xpsave["name"] == "")
				continue;
			if(!isset($xpsave["killrating"]))
				$xpsave["killrating"] = 1600;
			if(!isset($xpsave["player_rating"]))
				$xpsave["player_rating"] = "0.000000";
			if(!isset($xpsave["player_rating_variance"]))
				$xpsave["player_rating_variance"] = "50.000000";
			$xpsave["player_rating_variance"] /= 25.0;
			$xpsave["player_rating_variance"] = sqrt($xpsave["player_rating_variance"]);
			$xpsave["lower_rating"] = $xpsave["player_rating"] - 2*$xpsave["player_rating_variance"];
			$xpsave["kd"] = 1.0 / (1.0 + exp(-($xpsave["killrating"]-1600)/400.0));
			$xpsave["kd"] /= 1.0 - $xpsave["kd"];
			$xpsave["win"] = 1.0 / (1.0 + exp(-$xpsave["player_rating"]/sqrt(1.0+3*($xpsave["player_rating_variance"]*$xpsave["player_rating_variance"]*20)/(pi()*pi()))));
			$xpsave["win"] = sprintf("%.3f",$xpsave["win"]);
			$xpsave["kd"] = sprintf("%.3f",$xpsave["kd"]);
			$xpsaves[$xpsave["guid"]] = $xpsave;
			unset($xpsave);
		}
	}
	if(!is_array($xpsaves))
		return array();
	if($sort == "name") {
		$sort_ord = SORT_ASC;
		$sort_type = SORT_STRING;
	}
	else {
		$sort_ord = SORT_DESC;
		$sort_type = SORT_NUMERIC;
	}
	while (list(,$v) = each($xpsaves))
		$sort_ary[] = strtolower($v[$sort]);
	reset($xpsaves);
	array_multisort($sort_ary, $sort_type, $sort_ord, $xpsaves);
	return $xpsaves;
}
?>
