/*
 * $Id: etrace.c,v 1.1.1.1 2006/07/08 16:31:46 dave Exp $
 */
#include "etrace.h"
#include "options.h"
#include "packetfu.h"
#include "trace.h"

int
main (int argc, char *argv[]) {

	/*
	 * Get some entropy
	 */
	srand((unsigned)time(NULL) + getpid());

	/*
	 * Load default profile
	 */
	load_profile("default");

	/*
	 * Process command line arguments
	 */
	process_cmdline(argc, argv);

	/*
	 * Skip over options and ensure we have at least one target
	 */
	argc -= optind;
	argv += optind;
	if (argc == 0)
		errx(EX_USAGE, "No target specified");

	/*
	 * Add the default probe if no probes were specified
	 */
	if (probes.first == NULL)
		add_probe(DEFAULT_PROBE_PROTO, DEFAULT_PROBE_TYPE);

	/*
	 * Prepare for networking magic...
	 */
	network_startup();

	/*
	 * Process specified targets
	 */
	for ( ; argv[0]; argv++) {
		do_trace(argv[0]);
	}

	/*
	 * Shuwdown and exit
	 */
	network_shutdown();

	return(EX_OK);
}
