/*
 * $Id: etrace.h,v 1.1.1.1 2006/07/08 16:31:46 dave Exp $
 */
#ifndef __ETRACE__
#define __ETRACE__
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <err.h>
#include <limits.h>
#include <netdb.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <time.h>
#include <unistd.h>

#include "config.h"

#include <pcap.h>
#ifdef HAVE_DUMBNET
#include <dumbnet.h>
#else
#include <dnet.h>
#endif /* HAVE_DUMBNET */

#define	PROFILE_FILENAME	"profile"
#define	USER_PROFILE_FILENAME	".etrace"

#define	DEFAULT_PROBE_PROTO	ptICMP
#define	DEFAULT_PROBE_TYPE	icmpECHO

#define	DEFAULT_INITIAL_HOP	1
#define	DEFAULT_MAX_HOP		32
#define	DEFAULT_TCP_WIN		32768
#define	DEFAULT_IP_FRAGOFF	0

#define	MAX_PROBE_DESC		1024
#define	PROFILE_MAX_LINE_LEN	1024
#define	PROFILE_RECURSION_MAX	5
#define	MAX_HOP_MSG_LEN		128
#define	MAX_TTL_MSG_LEN		128
#define MAX_PKT_DATA_LEN	1500

#define	PCAP_TIMEOUT		100
#define	PCAP_SNAPLEN		1514
#define	PCAP_FILTER		"dst host %s and not arp"

#define	PROBE_DELIMS		":,"
#define	SHARE_DIR_CHAR		'@'

extern	char			pcap_version[];

#endif /* __ETRACE__ */
