/*
 * $Id: options.h,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#ifndef __OPTIONS__
#define __OPTIONS__
#include "etrace.h"
#include "profiles.h"
#include "probes.h"
#include "util.h"

#ifdef HAVE_GETOPT_LONG
#include "getopt.h"
#endif /* HAVE_GETOPT_LONG */

#define	SPEC_SRC_ADDR	0x0001
#define	SPEC_SRC_PORT	0x0002
#define	SPEC_TCP_SEQ	0x0004

typedef	struct __options {
	/* Interface Options */
	char		*interface;
	int		promisc;

	/* Trace Options */
	int		initial_hop;
	int		max_hop;
	int		probes;
	int		timeout;

	/* Packet Construction Options */
	struct in_addr	source_ip;
	int		source_port;
	int		ip_flags;
	int		tcp_flags;
	char		*data;
	int		datalen;
	int		badcksum;
	long int	tcp_seq;
	int		tcp_win;
	int		ip_fragoff;

	/* Output Options */
	int		loglevel;
	int		numeric;

	/* Internal Stuff */
	unsigned int	specified;
	struct in_addr	target;
} OPTIONS;

extern	OPTIONS		options;

void process_cmdline(int argc, char *argv[]);

#endif /* __OPTIONS__ */
