/*
 * $Id: output.c,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#include "output.h"

char	*loglevel_desc[] = {
	"Normal", "Verbose", "Debug", "Insane", NULL};

void
logmsg (int level, char *fmt, ...) {
	va_list		args;

	if (level > options.loglevel) return;

	va_start(args, fmt);
	vfprintf(stderr, fmt, args);
	va_end(args);
}

void display_hop (int hop, uint32_t *addr, int ttl, char *fmt, ...) {
	struct hostent	*host = NULL;
	va_list		args;
	char		msg[MAX_HOP_MSG_LEN];
	char		ttl_msg[MAX_TTL_MSG_LEN];

	va_start(args, fmt);
	vsnprintf(msg, MAX_HOP_MSG_LEN, fmt, args);
	va_end(args);

	if (!options.numeric && addr)
		host = gethostbyaddr((char *)addr, 4, AF_INET);

	if (ttl >= 0)
		snprintf(ttl_msg, MAX_TTL_MSG_LEN, " - TTL=%d", ttl);

	printf("%2d: %s (%s) [%s%s]\n",
	    hop,
	    addr ? inet_ntoa(*(struct in_addr *)addr) : "*",
	    host ? host->h_name : "\?\?",
	    msg, ttl >= 0 ? ttl_msg : "");
}
