/*
 * $Id: packetfu.h,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#ifndef __PACKETFU__
#define __PACKETFU__
#include "etrace.h"
#include "options.h"
#include "util.h"

struct  state_t {
        struct in_addr  dest_ip;
        int             ttl;
        int             attempt;
        int             complete;

        u_int16_t       ip_id;
        u_int16_t       src_port;
        u_int32_t       tcp_seq;
        u_int32_t       tcp_ack;
};
typedef struct state_t  STATE;

struct etrace_icmp_pkt {
	unsigned char   type;
	unsigned char   code;
	u_int16_t       checksum;
	u_int16_t       id;
	u_int16_t       seq;
	union {
		struct {
			u_int32_t       orig;
			u_int32_t       rec;
			u_int32_t       trans;
		} timestamp;
		u_int32_t       netmask;
	} payload;
};
#define	ts_orig		payload.timestamp.orig
#define ts_rec		payload.timestamp.rec
#define	ts_trans	payload.timestamp.trans
#define	nm_data		payload.netmask

extern	pcap_t	*pcap;
extern	char	*pcap_iface;
extern	int	datalink_len;

void network_startup(void);
char *target_iface(struct in_addr addr);
void pcap_init(char *ifname);
void send_packet(PROBE *probe, STATE *state);
int  process_packet(PROBE *probe, STATE *state, const u_char *packet, int pktlen);
void network_shutdown(void);

#endif /* __PACKETFU__ */
