/*
 * $Id: probes.c,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#include "probes.h"

char	*probetype_desc[] = {
	"Unknown", "icmp", "tcp", "udp", "protocol", NULL};

char	*icmpprobe_text[] = {
	"Unknown", "Echo", "Timestamp", "Netmask", "Info", NULL};

PROBE_LIST	probes = {0, 0};

void
add_probe(int type, int data) {
	PROBE		*new_probe;

	if ((new_probe = malloc(sizeof(PROBE))) == NULL)
		err(EX_OSERR, "malloc failure during new_probe()");
	new_probe->type = type;
	new_probe->data = data;
	new_probe->next = NULL;

	if (probes.first == NULL)
		probes.first = new_probe;
	else
		probes.last->next = new_probe;
	probes.last = new_probe;

	logmsg(llDEBUG, "Added probe %s\n", probe_desc(new_probe));
}

char *
probe_desc (PROBE *probe) {
	static char	buffer[MAX_PROBE_DESC];

	switch(probe->type) {
	case ptICMP:
		snprintf(buffer, MAX_PROBE_DESC, "icmp/%s",
		    icmpprobe_text[probe->data]);
		break;
	case ptTCP:
		snprintf(buffer, MAX_PROBE_DESC, "tcp/%d", probe->data);
		break;
	case ptUDP:
		snprintf(buffer, MAX_PROBE_DESC, "udp/%d", probe->data);
		break;
	case ptPROTO:
		snprintf(buffer, MAX_PROBE_DESC, "protocol/%d", probe->data);
		break;
	default:
		errx(EX_SOFTWARE, "Unknown trace type (%d) in probe_desc()",
		    probe->type);
	}

	return(buffer);
}

void
clear_probes (void) {
	PROBE		*probe, *temp;

	for (probe = probes.first; probe != NULL; probe = temp) {
		temp = probe->next;
		free(probe);
	}

	probes.first = NULL;
	probes.last = NULL;
}
