/*
 * $Id: probes.h,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#ifndef __PROBES__
#define __PROBES__
#include "etrace.h"
#include "output.h"

enum __probe_t {
	ptUNKNOWN, ptICMP, ptTCP, ptUDP, ptPROTO} probe_t;

enum __icmptype {
	icmpUNKNOWN, icmpECHO, icmpTIMESTAMP, icmpADDRESSMASK, icmpINFO};

struct	probe_t {
	unsigned int		type;
	unsigned int		data;
	unsigned int		attempt;
	struct probe_t		*next;
};
typedef	struct probe_t		PROBE;

struct	probe_list_t {
	PROBE			*first;
	PROBE			*last;
};
typedef	struct probe_list_t	PROBE_LIST;

extern	char		*probetype_desc[];
extern	PROBE_LIST	probes;

void add_probe(int type, int data);
char *probe_desc (PROBE *probe);
void clear_probes(void);

#endif /* __PROBES__ */
