/*
 * $Id: profiles.c,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#include "profiles.h"

int	profile_recursion = 0;

char	*profile_loc[] = {
	NULL,
	DATADIR "/" PACKAGE_NAME "/" PROFILE_FILENAME,
	NULL
};

void
add_profile_opt (int *argc, char **argv[], char *option) {
	logmsg(llINSANE, "Adding option %s\n", option);

	*argv = realloc(*argv, sizeof(char *) * ((*argc)+1));
	(*argv)[(*argc)++] = strdup(option);
}

int
load_profile(char *name) {
	FILE		*infile;
	char		buffer[PROFILE_MAX_LINE_LEN];
	char		*cp, *item;
	int		i, line, found;

	int		argc = 0;
	char		**argv = NULL;

	if (++profile_recursion > PROFILE_RECURSION_MAX)
		errx(EX_USAGE, "Maximum profile recursion depth reached!");

	logmsg(llVERBOSE, "Loading profile [%s]\n", name);

	if (profile_loc[0] == NULL) {
		if ((cp = getenv("HOME")) != NULL) {
			if ((profile_loc[0] = malloc(strlen(cp)+
			    strlen(USER_PROFILE_FILENAME)+1)) == NULL)
				err(EX_OSERR, "malloc failure");
			sprintf(profile_loc[0], "%s/%s", cp,
			    USER_PROFILE_FILENAME);
			logmsg(llDEBUG, "Home directoy = %s\n", profile_loc[0]);
		} else
			profile_loc[0] = strdup(".");
	}

	found = 0;
	for (i = 0; profile_loc[i] != NULL; i++) {

		if ((infile = fopen(profile_loc[i], "r")) == NULL)
			continue;

		line = 0;
		while (fgets(buffer, PROFILE_MAX_LINE_LEN, infile)) {
			line++;
			cp = strtok(buffer, " \t\r\n");
			if (cp == NULL || cp[0] == '#')
				continue;
			if (cp[0] == '[') {
				if (found == 1)
					break;
				if ((item = strtok(cp, "[]")) == NULL)
					continue;
				if (strcasecmp(item, name) == 0) {
					add_profile_opt(&argc, &argv, name);
					found = 1;
					continue;
				}
			} else if (found == 1) {
				while (cp != NULL) {
					add_profile_opt(&argc, &argv, cp);
					cp = strtok(NULL, " \t\r\n");
				}
			}
		}

		fclose(infile);

		if (found == 1) {
			argv = realloc(argv, sizeof(char *) * (argc+1));
			argv[argc+1] = NULL;

			i = optind;
			optind = 0;
			process_cmdline(argc, argv);
			optind = i;

			for (i = 0; i < argc; i++)
				free(argv[i]);
			free(argv);

			break;
		}
	}

	--profile_recursion;
	return(found);
}
