/*
 * $Id: util.c,v 1.1.1.1 2006/07/08 16:31:47 dave Exp $
 */
#include "util.h"

void hexdump (FILE *stream, const void *src, int len) {
	int 		i;
	char 		hex[128], ascii[128];
	unsigned char 	*cp = (unsigned char *)src;

	for (i = 0; i < len; i++) {
		if (!(i % 16)) {
			if (i) { fprintf(stream, "%-54s %s\n", hex, ascii); }
			sprintf(hex, "%04x: ", i);
			strcpy(ascii, "................");
		}
		sprintf((hex + 6) + (3 * (i % 16)), "%02x ", cp[i]);
		if (cp[i] > 32 && cp[i] < 128) { ascii[i % 16] = cp[i]; }
	}
	fprintf(stream, "%-54s %s\n", hex, ascii);
}

int expand_string (char *dest, char *src) {
	char *d = dest, *s = src, c;
	while((c = *s++)) {
		if (c == '\\' && *s) {
			switch(c = *s++) {
				case 'n': c = '\n'; break;
				case 'r': c = '\r'; break;
				case 't': c = '\t'; break;
				case '0': case '1': case '2': case '3':
				case '4': case '5': case '6': case '7':
					c -= '0';
					if (*s >= '0' && *s <= '7')
						c = c * 8 + (*s++ - '0');
					if (*s >= '0' && *s <= '7')
						c = c * 8 + (*s++ - '0');
					break;
				default : c = '\\'; break;
			}
		}
		*d++ = c;
	}
	return(d-dest);
}

char *icmp_description (int type, int code) {
	static char	buffer[1024];

	switch(type) {
	case 0:	/* Echo Reply */
		if (code == 0) strcpy(buffer, "Echo Reply");
			else sprintf(buffer, "Echo Reply (Code=%d)", code);
		break;
	case 3:	/* Destination Unreachable */
		switch (code) {
		case 0: strcpy(buffer, "Network Unreachable");
			break;
		case 1:	strcpy(buffer, "Host Unreachable");
			break;
		case 2:	strcpy(buffer, "Protocol Unreachable");
			break;
		case 3:	strcpy(buffer, "Port Unreachable");
			break;
		case 4:	strcpy(buffer, "Fragmentation Needed and Don\'t Fragment was Set");
			break;
		case 5:	strcpy(buffer, "Source Route Failed");
			break;
		case 6:	strcpy(buffer, "Destination Network Unknown");
			break;
		case 7:	strcpy(buffer, "Destination Host Unknown");
			break;
		case 8:	strcpy(buffer, "Source Host Isolated");
			break;
		case 9:	strcpy(buffer, "Network is Administratively Prohibited");
			break;
		case 10:strcpy(buffer, "Host is Administratively Prohibited");
			break;
		case 11:strcpy(buffer, "Network Unreachable for Type of Service");
			break;
		case 12:strcpy(buffer, "Host Unreachable for Type of Service");
			break;
		case 13:strcpy(buffer, "Communication Administratively Prohibited");
			break;
		case 14:strcpy(buffer, "Host Precedence Violation");
			break;
		case 15:strcpy(buffer, "Precedence cutoff in effect");
			break;
		default:sprintf(buffer, "Destination Unreachable (Code=%d)", code);
			break;
		}
		break;
	case 4:	/* Source Quench */
		if (code == 0) strcpy(buffer, "Source Quench");
			else sprintf(buffer, "Source Quench (Code=%d)", code);
		break;
	case 5:	/* Redirect */
		switch (code) {
		case 0: strcpy(buffer, "Network Redirect");
			break;
		case 1:	strcpy(buffer, "Host Redirect");
			break;
		case 2:	strcpy(buffer, "Type of Service Network Redirect");
			break;
		case 3: strcpy(buffer, "Type of Service Host Redirect");
			break;
		default:sprintf(buffer, "Redirect (Code=%d)", code);
			break;
		}
		break;
	case 6: /* Alternate Host Address */
		if (code == 0) strcpy(buffer, "Alternate Host Address");
			else sprintf(buffer, "Alternate Host Address (Code=%d)", code);
		break;
	case 8: /* Echo Request */
		if (code == 0) strcpy(buffer, "Echo Request");
			else sprintf(buffer, "Echo Request (Code=%d)", code);
		break;
	case 9: /* Router Advertisement */
		if (code == 0) strcpy(buffer, "Router Advertisement");
			else sprintf(buffer, "Router Advertisement (Code=%d)", code);
		break;
	case 10: /* Router Selection */
		if (code == 0) strcpy(buffer, "Router Selection");
			else sprintf(buffer, "Router Selection (Code=%d)", code);
		break;
	case 11: /* Time Exceeded */
		switch (code) {
		case 0: strcpy(buffer, "TTL Time Exceeded");
			break;
		case 1: strcpy(buffer, "Reassembly Time Exceeded");
			break;
		default:sprintf(buffer, "Time Exceeded (Code=%d)", code);
			break;
		}
		break;
	case 12: /* Parameter Problem */
		switch (code) {
		case 0: strcpy(buffer, "Parameter Problem - Pointer indicates the error");
			break;
		case 1: strcpy(buffer, "Parameter Problem - Missing a Required Option");
			break;
		case 2: strcpy(buffer, "Parameter Problem - Bad Length");
			break;
		default:sprintf(buffer, "Parameter Problem (Code=%d)", code);
			break;
		}
		break;
	case 13: /* Timestamp */
		if (code == 0) strcpy(buffer, "Timestamp");
			else sprintf(buffer, "Timestamp (Code=%d)", code);
		break;
	case 14: /* Timestamp Reply */
		if (code == 0) strcpy(buffer, "Timestamp Reply");
			else sprintf(buffer, "Timestamp Reply (Code=%d)", code);
		break;
	case 15: /* Information Request */
		if (code == 0) strcpy(buffer, "Information Request");
			else sprintf(buffer, "Information Request (Code=%d)", code);
		break;
	case 16: /* Information Reply */
		if (code == 0) strcpy(buffer, "Information Reply");
			else sprintf(buffer, "Information Reply (Code=%d)", code);
		break;
	case 17: /* Address Mask Request */
		if (code == 0) strcpy(buffer, "Address Mask Request");
			else sprintf(buffer, "Address Mask Request (Code=%d)", code);
		break;
	case 18: /* Address Mask Reply */
		if (code == 0) strcpy(buffer, "Address Mask Reply");
			else sprintf(buffer, "Address Mask Reply (Code=%d)", code);
		break;
	case 30: /* Traceroute */
		sprintf(buffer, "Traceroute (Code=%d)", code);
		break;
	case 31: /* Datagram Conversion Error */
		sprintf(buffer, "Datagram Conversion Error (Code=%d)", code);
		break;
	case 32: /* Mobile Host Redirect */
		sprintf(buffer, "Mobile Host Redirect (Code=%d)", code);
		break;
	case 33: /* IPv6 Where-Are-You */
		sprintf(buffer, "IPv6 Where-Are-You (Code=%d)", code);
		break;
	case 34: /* IPv6 I-Am-Here */
		sprintf(buffer, "IPv6 I-Am-Here (Code=%d)", code);
		break;
	case 35: /* Mobile Registration Request */
		sprintf(buffer, "Mobile Registration Request (Code=%d)", code);
		break;
	case 36: /* Mobile Registration Reply */
		sprintf(buffer, "Mobile Registration Reply (Code=%d)", code);
		break;
	case 39: /* SKIP */
		sprintf(buffer, "SKIP (Code=%d)", code);
		break;
	case 40: /* Photuris */
		switch (code) {
		case 0: strcpy(buffer, "Photuris - Reserved");
			break;
		case 1: strcpy(buffer, "Photuris - Unknown Security Parameters Index");
			break;
		case 2: strcpy(buffer, "Photuris - Authentication Failed");
			break;
		case 3: strcpy(buffer, "Photuris - Decryption Failed");
			break;
		default: sprintf(buffer, "Photuris (Code=%d)", code);
			break;
		}
		break;
	default: /* Anything else... */
		sprintf(buffer, "Unknown! (Type=%d, Code=%d)", type, code);
		break;
	}

	return(buffer);
}
