#! /bin/sh
# \
for dir in $(echo $PATH | sed 's/:/ /g'); \
do \
  if test -d $dir; \
  then \
    files=$(/bin/ls $dir | egrep '^tclsh[0-9]\.[0-9]$'); \
    if test "$files" != ""; \
    then \
      versions="${versions:+$versions }$(echo $files | sed 's/tclsh//g')"; \
    fi; \
  fi; \
done; \
# Loop over each version to find the latest version of tclsh \
for ver in $versions; \
do \
  tmpver=$(echo $ver | sed 's/\.//g'); \
  if test "$lasttmpver" != ""; \
  then \
    if test "$tmpver" -gt "$lasttmpver"; \
    then \
      lastver=$ver; \
      lasttmpver=$tmpver; \
    fi; \
  else \
    lastver=$ver; \
    lasttmpver=$tmpver; \
  fi; \
done; \
# Use the latest tclsh version found, otherwise fall back to 'tclsh' \
exec tclsh$lastver "$0" "$@"

# Evangeline v1.0+ Config-Wizard
# $Id: config-wizard.tcl, v1.0.1 2004/03/07 16:33:23 [Xp-AvR] Exp $

namespace eval ::wizard {

  set directory(binary) "binary"
  set directory(cfg) "cfg"
  set directory(src) "src"
  set eva(binary) "evangeline"

  ## Initialization ##

  # CheckStatus
  proc CheckStatus { } {
    global tcl_platform
    variable directory
    variable eva

    # Setting OS's dependant variables
    if {([string tolower $tcl_platform(platform)]=="unix")} then {
      set eva(ExecExtension) ""
      set eva(LinkExtension) ""
    } elseif {([string tolower $tcl_platform(platform)]=="windows")} {
      set eva(ExecExtension) ".exe"
      set eva(LinkExtension) ".lnk"
    }

    if {![file exist $directory(binary)]} then {
      cd ..
      if {[file exists $directory(src)] && [file isdirectory $directory(src)]} then {
        puts "[color 1]\[*\][color] Compile bot before creating config file"
        exit
      } elseif {![file exist $directory(binary)]} then {
        puts "[color 1]\[*\][color] I can't find $directory(binary), going down"
        exit
      }
    }
    if {![file writable $directory(cfg)]} then {
      puts "[color 1]\[*\][color] I can't write anything to $directory(cfg), going down"
      exit
    }
    return 0
  } ;# CheckStatus

  # IsNumber <string>
  proc IsNumber { string } {
    if {([string compare $string ""]) && ((![regexp -- \\. $string]) || ([regsub -- \\. $string "" string])) && \
        ((![regexp -- ^- $string]) || (([regsub -- ^- $string "" string]) && ($string != 0))) && (![regexp -- \[^0-9\] $string])} then {
      return 1
    }
    return 0
  }

  # color <number>
  proc color { {number 0} } { return "[format %c 27]\[0;${number}m" }

  # PrintLogo
  proc PrintLogo { } {
    puts "[color 1]"
    puts -nonewline "                                                                            \n"
    puts -nonewline "      _/_/_/ _/  _/  _/_/   _/   _/ _/_/_/ _/_/_/ _/     _/ _/   _/ _/_/_/  \n"
    puts -nonewline "     _/     _/  _/ _/   _/ _//  _/ _/     _/     _/        _//  _/ _/       \n"
    puts -nonewline "    _/_/   _/  _/ _/_//_/ _//_/_/ _/_/_/ _/_/   _/     _/ _//_/_/ _/_/      \n"
    puts -nonewline "   _/     _/  _/ _/   _/ _/  /_/ _/  _/ _/     _/     _/ _/  /_/ _/         \n"
    puts -nonewline "  _/_/_/  _/_/  _/   _/ _/   _/ _/_/_/ _/_/_/ _/_/_/ _/ _/   _/ _/_/_/      \n"
    puts -nonewline "           'MESS WITH THE BEST, DIE LIKE THE REST'                          \n"
    puts -nonewline "[color]\n\n"
  } ;# PrintLogo

  # GatherData
  proc GatherData { {bnick ""} } {
    variable directory
    variable eva

    PrintLogo

    # Ask for bot version to configure
    puts -nonewline "\n[color 1]Choose bot version \[Main/Slave/Alt\]:[color] "
    set BotVersion [string tolower [gets stdin]]
    while {($BotVersion != "main") && ($BotVersion != "slave") && ($BotVersion != "alt")} {
      puts "[color 1]\[*\][color] Choose correct version"
      set BotVersion [string tolower [gets stdin]]
    }

    # Ask for nickname
    if {$bnick == ""} then {
      puts -nonewline "\n[color 1]Enter bot nickname/botnet-nick (max. 9 chars):[color] "
      set eva(all:Botnick) [gets stdin]
      while {$eva(all:Botnick) == ""} {
        puts "[color 1]\[*\][color] You must enter something (max. 9 chars)"
        set eva(all:Botnick) [gets stdin]
      }
      if {[string length $eva(all:Botnick)] > 9} then {
        set eva(all:Botnick) [string range $eva(all:Botnick) 0 8]
      }
    } else {
      set eva(all:Botnick) $bnick
    }

    # Ask for port(s)
    puts -nonewline "\n[color 1]Enter bots port (From: 1024-65535):[color] "
    set eva(all:BotsPort) [gets stdin]
    while {(![IsNumber $eva(all:BotsPort)]) || ($eva(all:BotsPort) == "") || (($eva(all:BotsPort) < 1024) || ($eva(all:BotsPort) > 65535))} {
      puts "[color 1]\[*\][color] You must enter valid port"
      set eva(all:BotsPort) [gets stdin]
    }

    puts -nonewline "\n[color 1]Enter users port (From: 1024-65535):[color] "
    set eva(all:UsersPort) [gets stdin]
    while {(![IsNumber $eva(all:UsersPort)]) || ($eva(all:UsersPort) == "") || (($eva(all:UsersPort) < 1024) || ($eva(all:UsersPort) > 65535))} {
      puts "[color 1]\[*\][color] You must enter valid port"
      set eva(all:UsersPort) [gets stdin]
    }

    # Ask for bot ip (main/alt)
    if {($BotVersion == "main") || ($BotVersion == "alt")} then {
      puts -nonewline "\n[color 1]Enter bot's server ip:[color] "
      set eva(all:ServerIp) [gets stdin]
      while {(![regexp {\d+\.\d+\.\d+\.\d+} $eva(all:ServerIp)]) || ($eva(all:ServerIp) == "")} {
        puts "[color 1]\[*\][color] You must enter valid ip"
        set eva(all:ServerIp) [gets stdin]
      }
    }

    # Ask for alt type (main/slave)
    if {$BotVersion == "alt"} then {
      puts -nonewline "\n[color 1]Choose alt version \[main/slave\]:[color] "
      set eva(alt:Version) [gets stdin]
      while {($eva(alt:Version) != "main") && ($eva(alt:Version) != "slave")} {
        puts "[color 1]\[*\][color] Choose correct version"
        set eva(alt:Version) [gets stdin]
      }
    }

    CreateConfigFile $BotVersion
  } ;# GatherData

  proc CreateConfigFile { version } {
    variable directory
    variable eva

    set cfg [open $eva(all:Botnick).cfg w]
    puts -nonewline $cfg "#Evangeline: Config File (For Evangeline v1.0+)\n"
    puts -nonewline $cfg "\nnick \"$eva(all:Botnick)\""
    puts -nonewline $cfg "\nbotnet-nick \"$eva(all:Botnick)\""
    puts -nonewline $cfg "\nbots-listenport \"$eva(all:BotsPort)\""
    puts -nonewline $cfg "\nusers-listenport \"$eva(all:UsersPort)\""
    if {($version == "main") || (($version == "alt") && ($eva(alt:Version) == "main"))} then {
      puts -nonewline $cfg "\nmainip \"$eva(all:ServerIp)\""
      puts -nonewline $cfg "\nmy-ip \"\$mainip\""
    } else {
      puts -nonewline $cfg "\n#my-ip \"\""
    }
    puts -nonewline $cfg "\n"
    puts -nonewline $cfg "\nparty(plpass) \"\""
    puts -nonewline $cfg "\nparty(syspass) \"\""
    puts -nonewline $cfg "\nkeep-all-logs 0"
    puts -nonewline $cfg "\n"
    puts -nonewline $cfg "\n## DON'T TOUCH ANYTHING BELOW ##"
    puts -nonewline $cfg "\nloadstart \[clock clicks\]"
    if {$version == "main"} then {
      puts -nonewline $cfg "\nismain 1"
    } elseif {$version == "slave"} then {
      puts -nonewline $cfg "\nisslave 1"
    } elseif {$version == "alt"} then {
      if {$eva(alt:Version) == "main"} then {
        puts -nonewline $cfg "\nismalt 1"
      } elseif {$eva(alt:Version) == "slave"} then {
        puts -nonewline $cfg "\nissalt 1"
      }
    }
    puts -nonewline $cfg "\nlogfile mcobxsk * \"logs/\${botnet-nick}.log\""
    puts -nonewline $cfg "\nuserfile \"\${datadir}\${botnet-nick}.uf\""
    puts -nonewline $cfg "\nchanfile \"\${datadir}\${botnet-nick}.cf\""
    puts -nonewline $cfg "\n#Evangeline: [string toupper $version] Config"
    close $cfg
    if {![file exist $directory(cfg)/$eva(all:Botnick).cfg]} then {
      file copy -force $eva(all:Botnick).cfg $directory(cfg)/$eva(all:Botnick).cfg
      file delete -force $eva(all:Botnick).cfg
    }
  } ;# CreateConfigFile

} ;# namespace eval ::wizard

namespace eval ::Autorun {

  # Clear screen
  exec clear

  ::wizard::CheckStatus
  if {[lindex $argv 0] != ""} then {
    ::wizard::GatherData [lindex $argv 0]
  } else {
    ::wizard::GatherData
  }

} ;# namespace eval ::Autorun

