/*
 * share.h -- part of share.mod
 *
 * $Id: share.h,v 1.7 (0.5) 2003/12/18 23:09:42 [Xp-AvR] Exp $
 */

#ifndef _MODULES_SHARE_SHARE_H
#define _MODULES_SHARE_SHARE_H

#define UFF_OVERRIDE  0x000001  /* Override existing bot entries    */
#define UFF_INVITE    0x000002  /* Send invites in user file        */
#define UFF_EXEMPT    0x000004  /* Send exempts in user file        */
#define UFF_COMPRESS  0x000008  /* Compress the user file           */
#define UFF_ENCRYPT   0x000010  /* Encrypt the user file            */

/* Currently used priorities:
 *        0             UFF_OVERRIDE
 *        0             UFF_INVITE
 *        0             UFF_EXEMPT
 *       90             UFF_ENCRYPT
 *      100             UFF_COMPRESS
 */

typedef struct {
  char *feature;
  int flag;
  int (*ask_func) (int);
  int priority;
  int (*snd) (int, char *);
  int (*rcv) (int, char *);
} uff_table_t;

static int uff_writeenc(int idx, char *fname);
static int uff_readenc(int idx, char *fname);
static int write_tmp_userfile(char *fn, struct userrec *bu, int idx, char *key);
static struct userrec *dup_userlist(int t);

#ifndef MAKING_SHARE
/* 4 - 7 */
#define finish_share ((void (*) (int))share_funcs[4])
#define dump_resync ((void (*) (int))share_funcs[5])
#define uff_addtable ((void (*) (uff_table_t *))share_funcs[6])
#define uff_deltable ((void (*) (uff_table_t *))share_funcs[7])
/* 8 - 11 */
#endif /* !MAKING_SHARE */

#endif /* _MODULES_SHARE_SHARE_H */
