/*
 * inet_aton.c -- provides inet_aton() if necessary.
 *
 * $Id: inet_aton.c,v 1.15 (0.9) 2004/01/11 16:20:40 [Xp-AvR] Exp $
 */

#include "main.h"
#include "inet_aton.h"

#ifndef HAVE_ISASCII
#  define inet_isascii(x) 1 /* Let checks succeed if we don't have isascii(). */
#else
#  define inet_isascii(x) EvangelineIsascii(x)
#endif

#ifndef HAVE_INET_ATON

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)inet_addr.c	8.1 (Berkeley) 6/17/93";
static char rcsid[] = "$-Id: inet_addr.c,v 1.11 1999/04/29 18:19:53 drepper Exp $";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>
#include <sys/param.h>
#include <ctype.h>

int EvangelineInet_aton(cp, addr)
const char *cp;
struct in_addr *addr;
{
  static const u_32bit_t max[4] = { 0xffffffff, 0xffffff, 0xffff, 0xff };
  register u_32bit_t val;
  register int base;
  register int n;
  register char c;
  u_32bit_t parts[4];
  register u_32bit_t *pp = parts;

  EvangelineBzero(parts, sizeof(parts));

  c = *cp;
  for (;;) {
    if (!EvangelineIsdigit(c))
      goto ret_0;
    base = 10;
    if (c == '0') {
      c = *++cp;
      if (c == 'x' || c == 'X')
        base = 16, c = *++cp;
      else
        base = 8;
    }
    val = 0;
    for (;;) {
      if (EvangelineIsascii(c) && EvangelineIsdigit(c)) {
        val = (val * base) + (c - '0');
        c = *++cp;
      } else if (base == 16 && EvangelineIsascii(c) && EvangelineIsxdigit(c)) {
        val = (val << 4) | (c + 10 - (EvangelineIslower(c) ? 'a' : 'A'));
        c = *++cp;
      } else
        break;
    }
    if (c == '.') {
      if (pp >= parts + 3)
        goto ret_0;
      *pp++ = val;
      c = *++cp;
    } else
      break;
  }
  if (c != '\0' && (!EvangelineIsascii(c) || !EvangelineIsspace(c)))
    goto ret_0;
  n = pp - parts + 1;

  if (n == 0 ||
      parts[0] > 0xff || parts[1] > 0xff || parts[2] > 0xff ||
      val > max[n - 1])
    goto ret_0;

  val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);

  if (addr)
    addr->s_addr = htonl(val);
  return 1;

ret_0:
  return 0;
}
#endif /* !HAVE_INET_ATON */
