/*
 * inet_ntop.h --
 *
 * $Id: inet_ntop.h,v 1.3 2003/11/28 20:02:48 [Xp-AvR] Exp $
 */

#ifndef _EVANGELINE_COMPAT_INET_NTOP_H
#define _EVANGELINE_COMPAT_INET_NTOP_H

#include "src/main.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef USE_IPV6
#  ifndef HAVE_INET_NTOP
const char *EvangelineInet_ntop(int af, const void *src, char *dst, socklen_t size);
#  else
#    define EvangelineInet_ntop inet_ntop
#  endif
#else
#  define EvangelineInet_ntop 0
#endif

#endif /* !_EVANGELINE_COMPAT_INET_NTOP_H */
