/*
 * exp.c -- expansions (addons)
 *
 * $Id: exp.c,v 1.0.4 2004/03/29 13:23:56 [Xp-AvR] Exp $
 */

#include <sys/stat.h>
#include "main.h"
#include "modules.h"
#include "tandem.h"
#include "exp.h"
#include "md5/md5.h"
#ifdef HAVE_UNAME
#include <sys/utsname.h>
#endif
#include "crypt/ckeys.h"

extern struct userrec	*userlist;
extern char botnetnick[], userfile[], ver[], datadir[], moddir[];
extern int update_userfile, import_userfile, export_userfile;
extern time_t now;

char userfileCryptKey[512] = "secret.userfile.cryptkey";
char crcfileCryptKey[512] = "less.secret.crcfile.cryptkey";
char chanfileCryptKey[512] = "secret.chanfile.cryptkey";

void setCryptKeys() {
#ifndef DISABLE_CRYPT
  sprintf(userfileCryptKey, USERFILECK1, USERFILECK2);
#else
  strcpy(userfileCryptKey, "-DONTENCRYPTFILES-");
#endif
  sprintf(crcfileCryptKey, CRCCK1, CRCCK2);
  sprintf(chanfileCryptKey, CHANFILECK1, CHANFILECK2);
}

#ifdef PTRACE_DEBUG
/* Antydebug, from cNs by Crashev */
void ptraceAdebug(void) {
  int pid1, pid2;

  pid1 = getpid();
  if (!(pid1 = fork())) {
    pid2 = getpid();
    if (ptrace(PTRACE_ATTACH, pid2, 0, 0)) {
      ptrace(PTRACE_DETACH, pid1, 0, 0);
      kill(pid2, 9);
    }
    usleep(1000);
    ptrace(PTRACE_DETACH, pid2, 0, 0);
    exit(0);
  } else {
    waitpid(-1, NULL, WUNTRACED);
  }

  return;
}
#endif /* PTRACE_DEBUG */

#ifdef PT_DEBUG
/* Antydebug, BSD version */
void ptraceAdebug(void) {
  int pid1, pid2;

  pid1 = getpid();
  if (!(pid1 = fork())) {
    pid2 = getpid();
    if (ptrace(PT_ATTACH, pid2, 0, 0)) {
      ptrace(PT_DETACH, pid1, 0, 0);
      kill(pid2, 9);
    }
    usleep(1000);
    ptrace(PT_DETACH, pid2, 0, 0);
    exit(0);
  } else {
    waitpid(-1, NULL, WUNTRACED);
  }

  return;
}
#endif /* PT_DEBUG */

void initModule(char *x) {
  const char *p;
#ifndef STATIC
  char workbuf[1024];

  sprintf(workbuf, "%s%s." EVANGELINE_MOD_EXT, moddir, x);
  if (file_readable(workbuf)) {
#endif
    if ((p = module_load(x)) && ((!strcmp(p, MOD_NOSUCH)) || (!strcmp(p, MOD_LOADERROR)) || (!strcmp(p, MOD_CANTLOADMOD))))
      fatal("Initialization FAILED!", 0);
#ifndef STATIC
  }
#endif
}

/* Check tcl string for "hacks" */
int checkTclString(char *string) {
  if ((strstr(string, "adduser")) ||
      (strstr(string, "setuser")) ||
      (strstr(string, "getuser")) ||
      (strstr(string, "chhandle")) ||
      (strstr(string, "chattr")) ||
      (strstr(string, "chattr")) ||
      (strstr(string, "putbot")) ||
      (strstr(string, "putallbots")) ||
      (strstr(string, "botattr")) ||
      (strstr(string, "delhost")) ||
      (strstr(string, "addbot")) ||
      (strstr(string, "userlist")) ||
      (strstr(string, "channel")) ||
      (strstr(string, "ban")) ||
      (strstr(string, "ignore")) ||
      (strstr(string, "jump")) ||
      (strstr(string, "exec")) ||
      (strstr(string, "source")) ||
      (strstr(string, "exportUserfile")) ||
      (strstr(string, "putquick")) ||
      (strstr(string, "putserv")) ||
      (strstr(string, "puthelp")))
    return 1;
  else
    return 0;
}

/* Check config string to skip convering it */
int checkConfigString(char *string) {
  if ((strstr(string, "putlog ")) ||
      (strstr(string, "logfile ")) ||
      (strstr(string, "putlog ")) ||
      (strstr(string, "loadmodule ")) ||
      (strstr(string, "bind ")) ||
      (strstr(string, "catch ")) ||
      (strstr(string, "foreach ")) ||
      (strstr(string, "if ")) ||
      (strstr(string, "slang") && !strstr(string, "-slang ")) ||
      (strstr(string, "lappend ")) ||
      (strstr(string, "livestats ")))
    return 1;
  else
    return 0;
}

/* Modify string (keys) */
void doRot(int a, int b, char *c) {
  unsigned char r;

  r = c[a];
  while (a < b) {
   c[a] = c[a+1];
     a++;
  }
  c[a] = r;
}

/* fprintf with encryption */
int efprintf(FILE *f, char *key, char *fmt, ...) {
  va_list va;
  char outbuf[8192];
  char *tptr, *tptr2, *temps1, *temps2;
  int encrypt = 1;

  if (!strncmp(key, "-DONTENCRYPTFILES-", 18))
    encrypt = 0;
  va_start(va, fmt);
  vsnprintf(outbuf, sizeof(outbuf), fmt, va);
  tptr2 = outbuf;
  if(strchr(outbuf, '\n')) {
    while ((tptr = strchr(outbuf, '\n'))) {
      *tptr = 0;

      if (encrypt) {
        temps1 = (char *) encrypt_string(key, tptr2);
      } else {
        temps1 = nmalloc(strlen(tptr2) + 100);
        strcpy(temps1, tptr2);
      }
//      putlog(LOG_EDEBUG, "*", "efprintf() | Saved: %s | Encrypted: %s", outbuf, temps1);
      if (fprintf(f, "%s\n", temps1) == EOF) {
        nfree(temps1);
        return -1;
      }
      nfree(temps1);

      tptr++;
      tptr2 = tptr;
    }
  } else {
    if (encrypt) {
      temps2 = (char *) encrypt_string(key, outbuf);
    } else {
      temps2 = nmalloc(strlen(outbuf) + 100);
      strcpy(temps2, outbuf);
    }
//    putlog(LOG_EDEBUG, "*", "efprintf() | Saved: %s | Encrypted: %s", outbuf, temps2);
    if (fprintf(f, "%s", temps2) == EOF) {
      nfree(temps2);
      return -1;
    }
    nfree(temps2);
  }

  va_end(va);
  return 0;
}

/* MD5 Control sums generator */
char fullMd5Digest[33];
char *getMd5ControlSum(char *fname) {
  FILE *tmpfile;
  MD5_CTX md5context;
  unsigned char digest[16], buffer[1024];
  int n, i;

  fullMd5Digest[0] = 0;
  if ((tmpfile = fopen(fname, "r")) != NULL) {
    MD5_Init(&md5context);
    while ((n = fread(buffer, 1, sizeof(buffer), tmpfile)) > 0)
      MD5_Update(&md5context, buffer, n);
    MD5_Final(digest, &md5context);
    for (i = 0; i < 16; i++)
      sprintf(fullMd5Digest + (i * 2), "%.2x", digest[i]);
    fclose(tmpfile);
  }

  return fullMd5Digest;
}

/* Crc checking */
void generateFileCrc(char *fname) {
  FILE *crcfile, *tmpfile;
  char *actualCrc;
  char tmp[512], filename[128];

  sprintf(filename, "%s.%s.crc", datadir, botnetnick);
  crcfile = fopen(filename, "w");

  Context;
  actualCrc = getMd5ControlSum(fname);
//  putlog(LOG_EDEBUG, "*", "generateFileCrc() | Userfile: %s", actualCrc);
  efprintf(crcfile, crcfileCryptKey, "#UserfileCRC: %s\n", actualCrc);
  sprintf(tmp, "%s~bak", fname);
  if ((tmpfile = fopen(tmp, "r")) != NULL) {
    actualCrc = getMd5ControlSum(tmp);
//    putlog(LOG_EDEBUG, "*", "generateFileCrc() | Userfile backup: %s", actualCrc);
    efprintf(crcfile, crcfileCryptKey, "#BackupUserfileCRC: %s\n", actualCrc);
    fclose(tmpfile);
  }
  fclose(crcfile);
}

void checkFileCrc(char *fname) {
  FILE *crcfile, *tmpfile;
  int checkingUf=0, ok=0;
  char lastUserfCrc[512], lastBackupUserfCrc[512];
  char filename[128], tmps[512], tmp2[512], *tmp, *actualCrc;

//  putlog(LOG_EDEBUG, "*", "checkFileCrc() | Checking file: %s", fname);
  sprintf(filename, "%s.%s.crc", datadir, botnetnick);
  if ((crcfile = fopen(filename, "r")) != NULL) {
    fgets(tmps, 511, crcfile);
    while (!feof(crcfile)) {
      if (tmps[strlen(tmps)-1]=='\n')
        tmps[strlen(tmps)-1]=0;
      tmp = decrypt_string(crcfileCryptKey, tmps);
//      putlog(LOG_EDEBUG, "*", "checkFileCrc() | Saved crc: %s", tmp);
      if (!strncmp(tmp, "#UserfileCRC: ", 14))
        strcpy(lastUserfCrc, tmp);
      if (!strncmp(tmp, "#BackupUserfileCRC: ", 20))
        strcpy(lastBackupUserfCrc, tmp);
      fgets(tmps, 511, crcfile);
    }
    fclose(crcfile);
  }
  /* Checking userfile */
  checkingUf = 1;
  if (checkingUf) {
    Context;
    if ((tmpfile = fopen(fname, "r")) != NULL) {
      actualCrc = getMd5ControlSum(fname);
//      putlog(LOG_EDEBUG, "*", "checkFileCrc() | Crc: %s", actualCrc);
      sprintf(tmps, "#UserfileCRC: %s", actualCrc);
      if (!strcmp(tmps, lastUserfCrc))
        ok = 1;
      else
        ok = 0;
      fclose(tmpfile);
    } else {
      fatal(MISC_NOUSERFILE, 0);
    }
    if (!ok) {
      sprintf(tmp2, "%s~bak", fname);
      if ((tmpfile = fopen(tmp2, "r")) != NULL) {
        actualCrc = getMd5ControlSum(tmp2);
        sprintf(tmps, "#BackupUserfileCRC: %s", actualCrc);
        if (!strcmp(tmps, lastBackupUserfCrc)) {
          ok = 1;
          copyfile(tmp2, userfile);
        } else {
          ok = 0;
        }
        fclose(tmpfile);
      }
    }
  }
  if (!ok) {
    sprintf(tmps, "%s[!]%s No such file or file is corrupted: '%s%s%s'\n", WHITES, WHITE, RED, fname, WHITE);
    fatal(tmps, 0);
  }
}

/* decrypt old userfile (VoiD, AversE 1.8.6) */
int decryptUserfile(char *fname, int donly) {
  FILE *fin, *fout;
  char sign, file[100], buffer[1024], tmpfname[100]="";
  unsigned long test[14], key, tmp;
  int found=0, i=0, ok=0, mode=0, eggUserfile=0;
  time_t tt, tt2;

  Context;
  if ((fin = fopen(fname, "r")) == NULL) {
    sprintf(tmpfname, "%s%s.upu", datadir, botnetnick);
    if ((fin = fopen(tmpfname, "r")) == NULL) {
      sprintf(buffer, "%s[*]%s Can't open userfile: '%s%s%s'", WHITES, WHITE, RED, fname, WHITE);
      fatal(buffer, 0);
    } else {
      fname = tmpfname;
    }
  }
  Context;
  fgets(buffer, 1023, fin);
  if (!strncmp(buffer, "#4v: ", 5)) {
    eggUserfile = 1;
    goto readUserfile;
  } else if (strncmp(buffer, "#4!: ", 5)) {
    sprintf(buffer, "%s[*]%s Bad userfile format: '%s%s%s'", WHITES, WHITE, RED, fname, WHITE);
    fatal(buffer, 0);
  }

  fread(&test[0], sizeof(test[0]), 13, fin);
  fclose(fin);

  tt = time(0);
  putlog(LOG_MISC, "*", "Decrypting userfile: '%s%s%s'...", RED, fname, WHITE);

  for (mode=0; mode <= 3; mode++) {
    ok = 1;
    for (key=0; key < 0xFFFFFF; key++) {
      ok = 1;
      while (ok) {
        tmp = test[i];
        tmp-=(i*mode);
        tmp = tmp^key;

        if (i<10 && ((tmp == '-') || (tmp == ' ') || ((tmp > 47) && (tmp < 58)) || ((tmp > 64) && (tmp < 127))))
          ok = 1;
        else if ((i == 10) && (tmp == ' '))
          ok = 1;
        else if ((i == 11) && (tmp == '-'))
          ok = 1;
        else if ((i == 12) && (tmp == ' ')) {
          found = 1;
          ok = 0;
          break;
        } else {
          ok = 0;
        }

        if (ok)
          i++;
      }

      if (found)
        break;
    }
    if (found)
      break;
  }

  tt2 = time(NULL);
  fin = fopen(fname, "r");
  if (found) {
    fgets(buffer, 1023, fin);
    buffer[2] = 'v';
    sprintf(file, "%s.tmp", fname);
    if ((fout = fopen(file, "w")) == NULL) {
      sprintf(buffer, "%s[*]%s Can't create output file: '%s%s%s'", WHITES, WHITE, RED, file, WHITE);
      fatal(buffer, 0);
    }

    fwrite(&buffer, strlen(buffer), 1, fout);
    i=0;
    while (!feof(fin)) {
      fread(&tmp, sizeof(tmp), 1, fin);
      if (feof(fin))
        break;
      tmp-=(i++*mode);
      tmp = tmp^key;
      sign=tmp;
      fwrite(&sign, 1, 1, fout);
      if (sign == '\n')
        i =0;
    }
    fclose(fin);
    fclose(fout);
    putlog(LOG_MISC, "*", "%s[*]%s Decryption done. Key: %d", WHITES, WHITE, key);
    if (!donly) {
      sprintf(buffer, "%s.prv", fname);
      movefile(fname, buffer);
    }
    movefile(file, fname);
  } else {
    sprintf(buffer, "%s[*]%s Unsupported userfile: '%s%s%s'", WHITES, WHITE, RED, fname, WHITE);
    fatal(buffer, 0);
  }
readUserfile:
  if (!donly) {
    write_userfile(-1, userfileCryptKey);
    unlink(fname);
    update_userfile = 0;
  }
  return 1;
}

int decryptFile(char *input, char *output) {
  FILE *fin, *fout;
  char tmpStr[1024], s1[81], *decryptedStr;

  fin = fopen(input, "r");
  fout = fopen(output, "w");
  if (fin == NULL || fout == NULL) {
    putlog(LOG_MISC, "*", "Can't open/create file...\n");
    return 0;
  }
  fgets(tmpStr, 1023, fin); // signature
  strcpy(s1, ctime(&now));
  fprintf(fout, "#4v: %s -- %s -- written %s", ver, botnetnick, s1);
  fgets(tmpStr, 1023, fin);
  while (!feof(fin)) {
    if (tmpStr[strlen(tmpStr)-1] == '\n') tmpStr[strlen(tmpStr)-1] = 0;
    decryptedStr = decrypt_string(userfileCryptKey, tmpStr);
//    putlog(LOG_EDEBUG, "*", "decryptFile() | Encr: %s | Decr: %s", tmpStr, decryptedStr);
    fprintf(fout, "%s\n", decryptedStr);
    fgets(tmpStr, 1023, fin);
  }
  fclose(fin);
  fclose(fout);

  return 1;
}

void exportUserfile() {
  char fname[100];

  export_userfile = 1;
  write_userfile(-1, "-DONTENCRYPTFILES-");
  sprintf(fname, "%s%s.euf", datadir, botnetnick);
  copyfile(userfile, fname);
  if (is_compressedfile(fname))
    uncompress_file(fname);
  export_userfile = 0;
  write_userfile(-1, userfileCryptKey);

  putlog(LOG_MISC, "*", "Userfile exported to file: %s", fname);
  return;
}

/* Colours for TCL */
static int tcl_colour_white STDVAR
{
  Tcl_AppendResult(irp, WHITE, NULL);
  return TCL_OK;
}

static int tcl_colour_whites STDVAR
{
  Tcl_AppendResult(irp, WHITES, NULL);
  return TCL_OK;
}

static int tcl_colour_grays STDVAR
{
  Tcl_AppendResult(irp, GRAYS, NULL);
  return TCL_OK;
}

static int tcl_colour_blue STDVAR
{
  Tcl_AppendResult(irp, BLUE, NULL);
  return TCL_OK;
}

static int tcl_colour_red STDVAR
{
  Tcl_AppendResult(irp, RED, NULL);
  return TCL_OK;
}

static int tcl_colour_reds STDVAR
{
  Tcl_AppendResult(irp, REDS, NULL);
  return TCL_OK;
}

static int tcl_colour_greens STDVAR
{
  Tcl_AppendResult(irp, GREENS, NULL);
  return TCL_OK;
}

static int tcl_colour_violet STDVAR
{
  Tcl_AppendResult(irp, VIOLET, NULL);
  return TCL_OK;
}

static int tcl_colour_yellows STDVAR
{
  Tcl_AppendResult(irp, YELLOWS, NULL);
  return TCL_OK;
}

tcl_cmds tclexp_cmds[] =
{
/* Colours definition */
  {"white",  tcl_colour_white},
  {"whites", tcl_colour_whites},
  {"grays",  tcl_colour_grays},
  {"blue",   tcl_colour_blue},
  {"red",    tcl_colour_red},
  {"reds",   tcl_colour_reds},
  {"greens", tcl_colour_greens},
  {"violet", tcl_colour_violet},
  {"yellows",tcl_colour_yellows},
  {NULL,     NULL}
};
