#! /bin/sh
# \
for dir in $(echo $PATH | sed 's/:/ /g'); \
do \
  if test -d $dir; \
  then \
    files=$(/bin/ls $dir | egrep '^tclsh[0-9]\.[0-9]$'); \
    if test "$files" != ""; \
    then \
      versions="${versions:+$versions }$(echo $files | sed 's/tclsh//g')"; \
    fi; \
  fi; \
done; \
# Loop over each version to find the latest version of tclsh \
for ver in $versions; \
do \
  tmpver=$(echo $ver | sed 's/\.//g'); \
  if test "$lasttmpver" != ""; \
  then \
    if test "$tmpver" -gt "$lasttmpver"; \
    then \
      lastver=$ver; \
      lasttmpver=$tmpver; \
    fi; \
  else \
    lastver=$ver; \
    lasttmpver=$tmpver; \
  fi; \
done; \
# Use the latest tclsh version found, otherwise fall back to 'tclsh' \
exec tclsh$lastver "$0" "$@"

# Evangeline v1.0+ Config-Wizard
# $Id: config-wizard.tcl, v1.0.13 2005/01/18 20:34:23 [Xp-AvR] Exp $

namespace eval ::wizard {

  set directory(binary) "binary"
  set directory(cfg) "cfg"
  set directory(src) "src"
  set eva(binary) "evangeline"

  ## Initialization ##

  # CheckStatus
  proc CheckStatus { } {
    global tcl_platform
    variable directory
    variable eva

    # Setting OS's dependant variables
    if {([string tolower $tcl_platform(platform)]=="unix")} then {
      set eva(ExecExtension) ""
      set eva(LinkExtension) ""
    } elseif {([string tolower $tcl_platform(platform)]=="windows")} {
      set eva(ExecExtension) ".exe"
      set eva(LinkExtension) ".lnk"
    }

    if {![file exist $directory(binary)]} then {
      cd ..
      if {[file exists $directory(src)] && [file isdirectory $directory(src)]} then {
        puts "[color 1]\[*\][color] Compile bot before creating config file"
        exit
      } elseif {![file exist $directory(binary)]} then {
        puts "[color 1]\[*\][color] I can't find $directory(binary), going down"
        exit
      }
    }
    if {![file writable $directory(cfg)]} then {
      puts "[color 1]\[*\][color] I can't write anything to $directory(cfg), going down"
      exit
    }
    return 0
  } ;# CheckStatus

  # IsNumber <string>
  proc IsNumber { string } {
    if {([string compare $string ""]) && ((![regexp -- \\. $string]) || ([regsub -- \\. $string "" string])) && \
        ((![regexp -- ^- $string]) || (([regsub -- ^- $string "" string]) && ($string != 0))) && (![regexp -- \[^0-9\] $string])} then {
      return 1
    }
    return 0
  }

  # color <number>
  proc color { {number 0} } { return "[format %c 27]\[0;${number}m" }

  # PrintLogo
  proc PrintLogo { } {
    puts "[color 1]"
    puts -nonewline "                                                                            \n"
    puts -nonewline "      _/_/_/ _/  _/  _/_/   _/   _/ _/_/_/ _/_/_/ _/     _/ _/   _/ _/_/_/  \n"
    puts -nonewline "     _/     _/  _/ _/   _/ _//  _/ _/     _/     _/        _//  _/ _/       \n"
    puts -nonewline "    _/_/   _/  _/ _/_//_/ _//_/_/ _/_/_/ _/_/   _/     _/ _//_/_/ _/_/      \n"
    puts -nonewline "   _/     _/  _/ _/   _/ _/  /_/ _/  _/ _/     _/     _/ _/  /_/ _/         \n"
    puts -nonewline "  _/_/_/  _/_/  _/   _/ _/   _/ _/_/_/ _/_/_/ _/_/_/ _/ _/   _/ _/_/_/      \n"
    puts -nonewline "           'MESS WITH THE BEST, DIE LIKE THE REST'                          \n"
    puts -nonewline "[color]\n\n"
  } ;# PrintLogo

  # GatherData
  proc GatherData { {bnick ""} } {
    variable directory
    variable eva

    PrintLogo

    # Ask for bot version to configure
    puts -nonewline "\n[color 1]Choose bot version \[IPv4/IPv6/BNC\]:[color] "
    set BotVersion [string tolower [gets stdin]]
    while {($BotVersion != "ipv4") && ($BotVersion != "ipv6") && ($BotVersion != "bnc")} {
      puts "[color 1]\[*\][color] Choose correct version"
      set BotVersion [string tolower [gets stdin]]
    }

    # Ask for nickname
    puts -nonewline "\n[color 1]Enter bot nickname (max. 9 chars):[color] "
    set eva(all:Nickname) [gets stdin]
    while {$eva(all:Nickname) == ""} {
      puts "[color 1]\[*\][color] You must enter something (max. 9 chars)"
      set eva(all:Nickname) [gets stdin]
    }
    if {[string length $eva(all:Nickname)] > 9} then {
      set eva(all:Nickname) [string range $eva(all:Nickname) 0 8]
    }

    # Ask for botnet-nick
    if {$bnick == ""} then {
      puts -nonewline "\n[color 1]Enter botnet-nick (Hit 'enter' to use: $eva(all:Nickname)):[color] "
      set eva(all:Botnick) [gets stdin]
      if {$eva(all:Botnick) == ""} then {
        set eva(all:Botnick) $eva(all:Nickname)
      }
      if {[string length $eva(all:Botnick)] > 9} then {
        set eva(all:Botnick) [string range $eva(all:Botnick) 0 8]
      }
    } else {
      set eva(all:Botnick) $bnick
    }

    # Ask for realname
    puts -nonewline "\n[color 1]Enter realname (Hit 'enter' to use: \-=$eva(all:Nickname)\=-):[color] "
    set eva(all:Realname) [gets stdin]
    if {$eva(all:Realname) == ""} then {
      set eva(all:Realname) "\-=$eva(all:Nickname)\=-"
    }

    # Ask for port(s)
    puts -nonewline "\n[color 1]Enter port (From: 1024-65535):[color] "
    set eva(all:Port) [gets stdin]
    while {(![IsNumber $eva(all:Port)]) || ($eva(all:Port) == "") || (($eva(all:Port) < 1024) || ($eva(all:Port) > 65535))} {
      puts "[color 1]\[*\][color] You must enter valid port"
      set eva(all:Port) [gets stdin]
    }

    # Vhosts
    if {($BotVersion == "ipv4") || ($BotVersion == "ipv6")} then {
      puts -nonewline "\n[color 1]Would You like to configure vhosts? \[Y/n\]:[color] "
      set TmpVariable [string tolower [gets stdin]]
      if {($TmpVariable == "y") || ($TmpVariable == "")} then {
        if {$BotVersion == "ipv4"} then { ;# IPv4
          puts -nonewline "\n[color 1]Enter IP in IPv4 format (ex.: 212.75.23.98):[color] "
          set eva(ipv4:IpNumber) [gets stdin]
          while {![regexp {\d+\.\d+\.\d+\.\d+} $eva(ipv4:IpNumber)]} {
            puts "[color 1]\[*\][color] You must enter valid ip address"
            set eva(ipv4:IpNumber) [gets stdin]
          }
          puts -nonewline "\n[color 1]Enter hostname for choosen ip (ip: $eva(ipv4:IpNumber)):[color] "
          set eva(ipv4:Hostname) [gets stdin]
          if {$eva(ipv4:Hostname) == ""} then {
            set eva(ipv4:Hostname) $eva(ipv4:IpNumber)
          }
        } elseif {$BotVersion == "ipv6"} then { ;# IPv6
          puts -nonewline "\n[color 1]Enter IP in IPv4 format (ex.: 212.75.23.98):[color] "
          set eva(ipv4:IpNumber) [gets stdin]
          while {![regexp {\d+\.\d+\.\d+\.\d+} $eva(ipv4:IpNumber)]} {
            puts "[color 1]\[*\][color] You must enter valid ip address"
            set eva(ipv4:IpNumber) [gets stdin]
          }
          puts -nonewline "\n[color 1]Enter IP in IPv6 format (ex.: 3ffe:80ee:419:0:0:0:0:1):[color] "
          set eva(ipv6:IpNumber) [gets stdin]
          set eva(ipv6:Hostname) $eva(ipv6:IpNumber)
        }
      } else {
        set eva(ipv4:IpNumber) ""
        set eva(ipv6:IpNumber) ""
        set eva(ipv6:Hostname) $eva(ipv6:IpNumber)
      }
    } elseif {$BotVersion == "bnc"} then { ;# BNC
      puts -nonewline "\n[color 1]Enter username:[color] "
      set eva(bnc:Username) [gets stdin]
      while {$eva(bnc:Username) == ""} {
        puts "[color 1]\[*\][color] You must enter username"
        set eva(bnc:Username) [gets stdin]
      }
      puts -nonewline "\n[color 1]Choose BNC version \[BNC/psyBNC/ezBOUNCE\]:[color] "
      set eva(bnc:Version) [string tolower [gets stdin]]
      while {($eva(bnc:Version) != "bnc") && ($eva(bnc:Version) != "psybnc") && ($eva(bnc:Version) != "ezbounce")} {
        puts "[color 1]\[*\][color] Choose correct version"
        set eva(bnc:Version) [string tolower [gets stdin]]
      }
      puts -nonewline "\n[color 1]Enter BNC server address (ex.: server.net:3344):[color] "
      set eva(bnc:Address) [gets stdin]
      while {($eva(bnc:Address) == "") || (![IsNumber [lindex [split $eva(bnc:Address) :] 1]])} {
        puts "[color 1]\[*\][color] You must enter an address"
        set eva(bnc:Address) [gets stdin]
      }
      puts -nonewline "\n[color 1]Enter BNC password:[color] "
      set eva(bnc:Password) [gets stdin]
      while {$eva(bnc:Password) == ""} {
        puts "[color 1]\[*\][color] You must enter password"
        set eva(bnc:Password) [gets stdin]
      }
      puts -nonewline "\n[color 1]Enter BNC vhost (Hit 'enter' for default):[color] "
      set eva(bnc:Vhost) [gets stdin]
    }

    # Ask for irc server(s)
    puts -nonewline "\n[color 1]Would you like to change irc servers \[Y/n\]:[color] "
    set TmpVariable [string tolower [gets stdin]]
    if {($TmpVariable == "y") || ($TmpVariable == "")} then {
      if {$BotVersion == "bnc"} then {
        puts -nonewline "\n[color 1]Enter new servers (ex.: server.net server2.org):[color] "
      } else {
        puts -nonewline "\n[color 1]Enter new servers (ex.: server.net:6667 server2.org:6667):[color] "
      }
      set eva(ircservers) [string tolower [gets stdin]]
      while {$eva(ircservers) == ""} {
        puts "[color 1]\[*\][color] You must enter at least one server"
        set eva(ircservers) [string tolower [gets stdin]]
      }
    }

    # Ask for gseen module
    if {[file exist $directory(cfg)/gseen.mcfg]} then {
      puts -nonewline "\n[color 1]Use gseen module? \[Y/n\]:[color] "
      set eva(all:Gseen) [string tolower [gets stdin]]
      if {($eva(all:Gseen) == "y") || ($eva(all:Gseen) == "")} then {
        set eva(all:Gseen) 1
      } else {
        set eva(all:Gseen) 0
      }
    }

    # Ask for stats module
    if {[file exist $directory(cfg)/stats.mcfg]} then {
      puts -nonewline "\n[color 1]Use stats module? \[Y/n\]:[color] "
      set eva(all:Stats) [string tolower [gets stdin]]
      if {($eva(all:Stats) == "y") || ($eva(all:Stats) == "")} then {
        set eva(all:Stats) 1
      } else {
        set eva(all:Stats) 0
      }
    }
    CreateConfigFile $BotVersion
  } ;# GatherData

  proc CreateConfigFile { version } {
    variable directory
    variable eva

    set cfg [open $eva(all:Botnick).cfg w]
    puts -nonewline $cfg "#Evangeline: Config File (For Evangeline v1.0+)\n"
    puts -nonewline $cfg "\nnick \"$eva(all:Nickname)\""
    puts -nonewline $cfg "\naltnick \"$eva(all:Nickname)?\""
    puts -nonewline $cfg "\nbotnet-nick \"$eva(all:Botnick)\""
    puts -nonewline $cfg "\nrealname \"$eva(all:Realname)\""
    if {$version != "bnc"} then {
      puts -nonewline $cfg "\nusername \"$eva(all:Botnick)\""
    } else {
      puts -nonewline $cfg "\nusername \"$eva(bnc:Username)\""
    }
    puts -nonewline $cfg "\nlistenport $eva(all:Port)"
    if {$version != "bnc"} then {
      if {[info exist eva(ircservers)]} then {
        puts -nonewline $cfg "\nircservers { $eva(ircservers) }"
      } else {
        if {$version == "ipv4"} then {
          puts -nonewline $cfg "\nircservers { poznan.irc.pl:6663 lublin.irc.pl:7776 warszawa.irc.pl:6667 krakow.irc.pl:6667 }"
        } elseif {$version == "ipv6"} then {
          puts -nonewline $cfg "\nircservers { warszawa6.irc.pl irc6.ngnet.it:6667 irc6.edisontel.it:6667 ircd.stealth.net:6666 irc.missingu.com:6667 irc6.net:6667 }"
        }
      }
    }
    if {$version == "bnc"} then {
      if {$eva(bnc:Version) == "bnc"} then {
        puts -nonewline $cfg "\nuse-bnc 1"
      } elseif {$eva(bnc:Version) == "psybnc"} then {
        puts -nonewline $cfg "\nuse-psyBNC 1"
      } elseif {$eva(bnc:Version) == "ezbounce"} then {
        puts -nonewline $cfg "\nuse-ezBOUNCE 1"
      }
      puts -nonewline $cfg "\nservers \"$eva(bnc:Address)\""
      puts -nonewline $cfg "\nbnc-pass \"$eva(bnc:Password)\""
      puts -nonewline $cfg "\nbnc-host \"$eva(bnc:Vhost)\""
      if {[info exist eva(ircservers)]} then {
        puts -nonewline $cfg "\nircserver \"$eva(ircservers)\""
      } else {
        puts -nonewline $cfg "\nircserver \"poznan.irc.pl wroclaw.irc.pl lublin.irc.pl warszawa.irc.pl krakow.irc.pl\""
      }
      puts -nonewline $cfg "\niserv-port 6667"
    } elseif {$version == "ipv4"} then {
      if {([info exist eva(ipv4:IpNumber)]) && ($eva(ipv4:IpNumber) != "")} then {
        puts -nonewline $cfg "\nmy-ip \"$eva(ipv4:IpNumber)\""
        puts -nonewline $cfg "\nmy-hostname \"$eva(ipv4:Hostname)\""
      } else {
        puts -nonewline $cfg "\n#my-ip \"\""
        puts -nonewline $cfg "\n#my-hostname \"\""
      }
    } elseif {$version == "ipv6"} then {
      if {([info exist eva(ipv6:IpNumber)]) && ($eva(ipv6:IpNumber) != "")} then {
        puts -nonewline $cfg "\nuse-ipv6 1"
	puts -nonewline $cfg "\nmy-ip \"$eva(ipv4:IpNumber)\""
        puts -nonewline $cfg "\n#my-hostname \"\""
        puts -nonewline $cfg "\nmy-ip6 \"$eva(ipv6:IpNumber)\""
        puts -nonewline $cfg "\nmy-hostname6 \"\${my-ip6}\""
      } else {
        puts -nonewline $cfg "\nuse-ipv6 1"
	puts -nonewline $cfg "\nmy-ip \"$eva(ipv4:IpNumber)\""
        puts -nonewline $cfg "\n#my-hostname \"\""
        puts -nonewline $cfg "\n#my-ip6 \"\""
        puts -nonewline $cfg "\n#my-hostname6 \"\""
      }
    }
    puts -nonewline $cfg "\n"
    if {[info exist eva(all:Gseen)]} then {
      if {$eva(all:Gseen)} then {
        puts -nonewline $cfg "\nuse-gseen 1"
      } else {
        puts -nonewline $cfg "\nuse-gseen 0"
      }
    }
    if {[info exist eva(all:Stats)]} then {
      if {$eva(all:Stats)} then {
        puts -nonewline $cfg "\nuse-stats 1"
      } else {
        puts -nonewline $cfg "\nuse-stats 0"
      }
    }
    puts -nonewline $cfg "\n"
    puts -nonewline $cfg "\n## DON'T TOUCH ANYTHING BELOW ##"
    puts -nonewline $cfg "\nloadstart \[clock clicks\]"
    if {$version == "bnc"} then {
      puts -nonewline $cfg "\nbnc-server \[lindex \$ircserver \[rand \[llength \$ircserver\]\]\]"
    } else {
      puts -nonewline $cfg "\nservers \$ircservers"
    }
    puts -nonewline $cfg "\nlogfile mcobxsk * \"logs/\${botnet-nick}.log\""
    puts -nonewline $cfg "\nuserfile \"\${datadir}\${botnet-nick}.uf\""
    puts -nonewline $cfg "\nchanfile \"\${datadir}\${botnet-nick}.cf\""
    puts -nonewline $cfg "\n#Evangeline: [string toupper $version] Config"
    close $cfg
    if {![file exist $directory(cfg)/$eva(all:Botnick).cfg]} then {
      file copy -force $eva(all:Botnick).cfg $directory(cfg)/$eva(all:Botnick).cfg
      file delete -force $eva(all:Botnick).cfg
    }
  } ;# CreateConfigFile

} ;# namespace eval ::wizard

namespace eval ::Autorun {

  # Clear screen
  exec clear

  ::wizard::CheckStatus
  if {[lindex $argv 0] != ""} then {
    ::wizard::GatherData [lindex $argv 0]
  } else {
    ::wizard::GatherData
  }

} ;# namespace eval ::Autorun

