#! /bin/sh
# \
for dir in $(echo $PATH | sed 's/:/ /g'); \
do \
  if test -d $dir; \
  then \
    files=$(/bin/ls $dir | egrep '^tclsh[0-9]\.[0-9]$'); \
    if test "$files" != ""; \
    then \
      versions="${versions:+$versions }$(echo $files | sed 's/tclsh//g')"; \
    fi; \
  fi; \
done; \
for ver in $versions; \
do \
  tmpver=$(echo $ver | sed 's/\.//g'); \
  if test "$lasttmpver" != ""; \
  then \
    if test "$tmpver" -gt "$lasttmpver"; \
    then \
      lastver=$ver; \
      lasttmpver=$tmpver; \
    fi; \
  else \
    lastver=$ver; \
    lasttmpver=$tmpver; \
  fi; \
done; \
exec tclsh$lastver "$0" "$@"
# ABotchk - An Eggdrop/Evangeline utility to autogenerate botchk/crontab entries
# Copyright (C) 1999, 2000, 2001, 2002 Jeff Fisher (guppy@eggheads.org)
# Copyright (C) 2003, 2004 [Xp-AvR]
#
# $Id: abotchk.tcl,v 1.11 (1.0.0) 2004/07/09 00:10:23 [Xp-AvR] Exp $

if {$argc == 0} {
  puts "\nusage: $argv0 <config> \[options\]"
  puts " -dir     (directory to run autobotchk in)"
  puts " -noemail (discard crontab e-mails)"
  puts " -5       (5 minute checks)"
  puts " -10      (10 minute checks)"
  puts " -15      (15 minute checks)"
  puts " -30      (30 minute checks)"
  puts ""
  exit
}

fconfigure stdout -buffering none

proc newsplit {text {split " "}} {
  upvar $text ours
  append ours $split
  set index [string first $split $ours]
  if {$index == -1} {
    set ours ""
    return ""
  }
  set tmp [string trim [string range $ours 0 $index]]
  set ours [string trim [string range $ours [expr $index + [string length $split]] end]]
  return $tmp
}

set target "binary/cron/"
set config [newsplit argv]
set dir [pwd]
set delay 10
set email 0

set binary "evangeline"

while {[set opt [newsplit argv]] != ""} {
  switch -- $opt {
   "-time" -
   "-1" { set delay 1 }
   "-5" { set delay 5 }
   "-10" { set delay 10 }
   "-15" { set delay 15 }
   "-20" { set delay 20 }
   "-30" { set delay 30 }
   "-email" { set email 1 }
   "-dir" {
      set dir [newsplit argv]
      if {[string match -* $dir]} {
        puts "*** ERROR: you did not supply a directory name"
        puts ""
        exit
      }
      if {![file isdirectory $dir]} {
        puts "*** ERROR: the directory you supplied is not a directory"
        puts ""
        exit
      }
    }
  }
}
set rnd [lindex [split [expr rand()] ""] 2]
switch -- $delay {
  "30" { set minutes "[expr 0 + $rnd],[expr 30 + $rnd]" }
  "20" { set minutes "[expr 0 + $rnd],[expr 20 + $rnd],[expr 40 + $rnd]" }
  "15" { set minutes "[expr 0 + $rnd],[expr 15 + $rnd],[expr 30 + $rnd],[expr 45 + $rnd]" }
  "5" { set minutes "0,5,10,15,20,25,30,35,40,45,50,55" }
  "1" { set minutes "*" }
  default { set minutes "0,10,20,30,40,50" }
}

set dir [string trimright $dir /]

if {![file exists $dir/$binary]} {
  puts "*** ERROR: are you sure you are running from a bot directory?"
  puts ""
  exit
}

puts "Opening '$config' for processing ..."
if {[catch {open $dir/$config.cfg r} fd]} {
  puts "error:"
  puts "  $fd\n"
  exit
}

puts "Scanning the config file ..."
while {![eof $fd]} {
  set line [gets $fd]
  switch -- [set opt [newsplit line]] {
    "nick" -
    "userfile" -
    "botnet-nick" {
      set $opt [string trim [newsplit line] " \""]
    }
  }
}
close $fd

if {![info exists {botnet-nick}] && [info exists nick]} {
  puts "  Defaulting \$botnet-nick to \"$nick\""
  set botnet-nick $nick
}
set pidfile ".data/.bdata/.pid.${botnet-nick}"
if {![info exists {botnet-nick}] || ![info exists userfile]} {
  puts "  *** ERROR: could not find either \$userfile or \$botnet-nick"
  puts ""
  puts "  Are you sure this is a valid Evangeline config file?"
  puts ""
  exit
}
if {![file exists $dir/$target]} then {
   file mkdir $dir/$target
}
if {[catch {open $dir/$target${botnet-nick}.bchk w} fd]} {
  puts "  *** ERROR: unable to open '${botnet-nick}.bchk' for writing"
  puts ""
  exit
}
puts $fd "#! /bin/sh
#
# \$Id: ${botnet-nick}.bchk,v 1.6 (1.0.0) [clock format [clock seconds] -format "%Y/%m/%d %H:%M:%S"] Exp \$

config=\"$config.cfg\"

## DON'T CHANGE ANYTHING BELOW ##
botdir=$dir
binary=\"$binary\"
cd \$botdir

botname=`cat \$config | grep \"botnet-nick \" | awk '{print \$2}' | sed s/'\"'// | sed s/'\"'//`
if \[ \"\$botname\" = \"\$nick\" \]; then
  botname=`cat \$config | grep \"nick \" | awk '{print \$2}' | sed s/'\"'// | sed s/'\"'//`
fi
userfile=\".data/.bdata/\$botname.uf\"
pidfile=\".data/.bdata/.pid.\$botname\"

if test -r \$pidfile
then
  botpid=`cat \$pidfile`
  if `kill -CHLD \$botpid >/dev/null 2>&1`
  then
    exit 0
  fi
  echo \"\"
  echo \"Stale \$pidfile file, erasing...\"
  rm -f \$pidfile
fi

echo \"\"
echo \"Couldn't find bot '\$botname' running, reloading...\"
echo \"\"
if \[ -f \$userfile \] || \[ -f \$userfile~bak \]
then
  ./\$binary \$config
  exit 0
else
  echo \"No userfile. Couldn't reload the bot...\"
  exit 1
fi

exit 0"

close $fd
puts "Wrote '${botnet-nick}.bchk' successfully ([file size $dir/$target${botnet-nick}.bchk] bytes)"
if {[catch {exec chmod u+x $dir/$target${botnet-nick}.bchk} 0]} {
  puts "  *** ERROR: unable to 'chmod u+x' the output file"
  puts ""
  exit
}
puts "Scanning crontab entries ... "

set tmp ".abotchk[clock clicks].[pid]"
if {$email} {
  set line "$minutes \* \* \* \* $dir/$target${botnet-nick}.bchk"
} {
  set line "$minutes \* \* \* \* $dir/$target${botnet-nick}.bchk >\/dev\/null 2>&1"
}

if {[catch {exec crontab -l > $tmp} error ]} {
  if {![string match "*no*cron*" [string tolower $error]] &&
      ![string match "*can't open*" [string tolower $error]]} {
    catch {file delete -force $tmp} 0
    puts "error: unable to get crontab listing"
    puts ""
    puts $error
    puts ""
    exit
  }
}

set fd [open $tmp r]
while {![eof $fd]} {
  set z [gets $fd]
  if {[string match "*$dir/$target${botnet-nick}.bchk*" $z] ||
      [string match "*$dir/$target${botnet-nick}.bchk*" $z]} {
    puts "Found an existing entry, we're done now"
    puts ""
    close $fd
    file delete $tmp
    exit
  }
}

close $fd

puts "Adding the new crontab entry ..."
set fd [open $tmp a]
puts $fd $line
close $fd

if {[catch {exec crontab $tmp} error]} {
  puts "error: unable to do 'crontab $tmp'"
  puts ""
  puts $error
  puts ""
  exit
} else {
  catch {file delete -force $tmp} 0
}

puts ""
puts "Use 'crontab -l' to view all your current crontab entries"
puts "    'crontab -r' to remove all your crontab entries"
puts ""
