/* suname.c -- handles:
 *   Simple uname
 *
 * $Id: suname.c,v 1.3 2004/02/14 12:14:34 [Xp-AvR] Exp $
 */

#include <stdio.h>
#include <sys/utsname.h>

int main(int argc, char **argv) {
  struct utsname un;
  int i, j;

  uname(&un);

  if (argc > 1) {
    for (i = 1; i < argc; i++) {
      if (argv[i][0] == '-') {
        for (j = 1; j < strlen(argv[i]); j++) {
          switch (argv[i][j]) {
            case 'a':
              printf("%s %s %s %s %s", un.sysname, un.nodename, un.release, un.version, un.machine);
              break;
            case 's':
              printf("%s", un.sysname);
              break;
            case 'r':
              printf("%s", un.release);
              break;
            case 'n':
              printf("%s", un.nodename);
              break;
            case 'v':
              printf("%s", un.version);
              break;
            case 'm':
              printf("%s", un.machine);
              break;
          }
          if (strlen(argv[i]) > 2)
            printf(" ");
        }
        printf("\n");
      }
    }
  } else {
    printf("%s\n", un.sysname);
  }
  return 0;
} /* main */

