/* chaos.c -- part of irc.mod
 * Kicking, opping (and mode) system
 *
 * $Id: chaos.c,v 1.0.9 2005/10/28 21:40:23 Arcain Exp $
 */

/* Prc & other variables */
char kickBreakp[1] = ",";
char opBreakp[1] = " ";

/* Functions prototypes. Move to irc.h later */
int howManyOfThem(char *string, char *breakp, int countOnly);
void chaos_markAsPending(char *channel, char *nicks, char *breakp);
void chaos_flushKick(char *channel, char *nicks, char *reason, int prc, int fastkick);
void chaos_flushOp(char *channel, char *nicks, char *opType, int prc, int fastkick);
void chaos_checkChannel(struct chanset_t *chan);
void chaos_checkChannelDelay();

/* Kick reasons */
char reasonMain[20] = "\0033\002Evangeline\002:\0033 ";
const char *randomReason() {
  static const char *kreasons[] = {
    "\0032\002Warrior Kings\002\0032",
    "\0032\002See you next time, bABY ;)\002\0032",
    "\0032\002Keep tryin'\002\0032",
    "\0032\002Your worse nightmare\002\0032",
    "\0032\002Head Shoot!\002\0032",
    "\0032\002Need help?\002\0032",
    "\0032\002Fuck the system!\002\0032",
    "\0032\002Looking for new friends?\002\0032",
    "\0032\002Next generation\002\0032",
    "\0032\002Fear Of The Dark?\002\0032",
    "\0032\002Farewell\002\0032",
    "\0032\002Be Quick Or Be Dead\002\0032",
    "\0032\002Angel Of The Morning\002\0032",
    "\0032\002By3!\002\0032",
    "",
  };
  const int ksize = sizeof kreasons/sizeof *kreasons;
  int knum = random() % ksize;
  return kreasons[knum];
}

/* BEGIN: Misc */

int ident[HANDLEN*51];
int howManyOfThem(char *string, char *breakp, int countOnly) {
  int i = 0, howmany = 0;

  for (i=0;i <= strlen(string); i++) {
    if (string[i] == breakp[0]) {
      howmany++;
      if (!countOnly)
        ident[howmany]=i;
    }
  }

  return howmany+1;
}

/* Randomise list */
char *sortUsers(char *list, char *breakp) {
  int i=0, i2=0, tmpi=0, id=0, cnt=0, cnt2=0, jt=0;
  char toutput[strlen(list) + 1], output[strlen(list) + 1], *olist;

  srandom(time(0) % (getpid() + getpid())); // Random number, i hope so ;)
  olist = nmalloc(strlen(list)+10);
  olist[0] = 0;
  cnt = howManyOfThem(list, breakp, 0);
  sortAgain:
  for (i=0; i <= cnt; i++) {
    jt = random() % time(0);
    id = random() % cnt;
    if (id == 0)
      tmpi = 0;
    else
      tmpi = 1;
    sprintf(toutput, "%s", &list[ident[id]+tmpi]);
    for (i2=0; i2 <= strlen(toutput); i2++) {
      if (toutput[i2] == breakp[0]) {
        toutput[i2] = 0;
        sprintf(output, "%s%c", toutput, breakp[0]);
        if (!strstr(olist, output)) {
          strcat(olist, output);
          i--;
        }
      }
    }
    srandom((time(0) % jt) % (getpid() + getpid()));
  }
  cnt2 = howManyOfThem(olist, breakp, 1);
  if (cnt2 < cnt)
    goto sortAgain;

  debug1("(chaos.c->sortUsers) sorted: %s", olist);
  return olist;
}

/* Mark nick(s) as pending kick/op */
void chaos_markAsPending(char *channel, char *nicks, char *breakp) {
  memberlist *m;
  struct chanset_t *chan;
  char toutput[1024];
  int i, i2, cnt=0, id=-1, tmpi;

  if (!nicks[0])
    return;
  cnt = howManyOfThem(nicks, breakp, 0);
  chan = findchan(channel);
  for (i=0; i <= cnt-1; i++) {
    id++;
      if (id == 0)
        tmpi = 0;
      else
        tmpi = 1;
      sprintf(toutput, "%s", &nicks[ident[id]+tmpi]);
      for (i2=0; i2 <= strlen(toutput); i2++) {
        if (toutput[i2] == breakp[0]) {
        markAgain:
        toutput[i2] = 0;
        m = ismember(chan, toutput);
        if (!m)
          continue;
        if (breakp[0] == ',') {
          debug1("(chaos.c->markAsPendning) Marking %s as kicked", toutput);
          m->flags |= SENTKICK;
        } else if (breakp[0] == ' ') {
          debug1("(chaos.c->markAsPendning) Marking %s as opped", toutput);
          m->flags |= CHANOP;
        }
      } else if (i2 == strlen(toutput)) {
        goto markAgain;
      }
    }
  }

  return;
}

/* END OF: Misc */

/* BEGIN: Kick section */

/* Flush kick
 * Usage:
 *  chaos_flushKick("channel", nicklist, reason, prc, "0-4kick/1-6kick");
 */
void chaos_flushKick(char *channel, char *nicks, char *reason, int prc, int fastkick) {
  char chaos_knicks[HANDLEN*51 + 1] = "";
  char kickNicks1[128] = "";
  char kickNicks2[128] = "";
  char outputr[400] = "";
  char *tmpoutput;
  int chaos_kcount = 0;

  chaos_knicks[0]=0;
  strcat(chaos_knicks, nicks);
  chaos_kcount = howManyOfThem(nicks, kickBreakp, 0);

  debug3("(chaos.c->flushKick) flusking %d kicks on %s: %s", chaos_kcount, channel, chaos_knicks);

  if (strncmp(reason, "-AUTO-", 6)) {
    strcpy(outputr, reason);
  } else {
    strcpy(outputr, reasonMain);
    outputr[strlen(outputr)] = 0;
    strcat(outputr, randomReason());
  }

  if (!fastkick) {
    if (chaos_kcount > 4) {
      tmpoutput = sortUsers(chaos_knicks, kickBreakp);
      strcpy(chaos_knicks, tmpoutput);
      chaos_kcount = howManyOfThem(chaos_knicks, kickBreakp, 0);
      chaos_knicks[ident[4]]=0;
      nfree(tmpoutput);
    }
    chaos_markAsPending(channel, chaos_knicks, kickBreakp);
    debug0("chaos.c->flushKick) !fastkick, marked as pending");
    dprintf(DP_MODE, "KICK %s %s :%s\n", channel, chaos_knicks, outputr);
  } else {
    if (chaos_kcount <= 4) {
      chaos_markAsPending(channel, chaos_knicks, kickBreakp);
      debug0("chaos.c->flushKick) fastkick <= 4, marked as pending");
      dprintf(DP_MODE, "KICK %s %s :%s\n", channel, chaos_knicks, outputr);
    } else if (chaos_kcount >= 5) {
      if (chaos_kcount > 6) {
        tmpoutput = sortUsers(chaos_knicks, kickBreakp);
        strcpy(chaos_knicks, tmpoutput);
        chaos_kcount = howManyOfThem(chaos_knicks, kickBreakp, 0);
        debug1("chaos.c->flushKick) to kick %d, trimming to 6", chaos_kcount);
        chaos_knicks[ident[6]]=0;
        nfree(tmpoutput);
      }
      strcpy(kickNicks1, chaos_knicks);
      kickNicks1[ident[2]]=0;
      strcpy(kickNicks2, &chaos_knicks[ident[2]+1]);
      chaos_markAsPending(channel, kickNicks1, kickBreakp);
      chaos_markAsPending(channel, kickNicks2, kickBreakp);
      debug0("chaos.c->flushKick) fastkick >= 5, marked as pending");
      dprintf(DP_MODE, "KICK %s %s :%s\nKICK %s %s :%s\n", channel, kickNicks1, outputr, channel, kickNicks2, outputr);
    }
  }
}

/* END OF: Kick section */

/* BEGIN: Op section */

/* Flush op
 * Usage:
 *  chaos_flushOp("channel", nicklist, "+/-", prc, 0-3op/1-5op");
 */
void chaos_flushOp(char *channel, char *nicks, char *opType, int prc, int fastop) {
  char chaos_onicks[HANDLEN*51 + 1] = "";
  char opString[3]="";
  char opNicks1[128] = "";
  char opNicks2[128] = "";
  char *tmpoutput;
  int chaos_ocount = 0;

  chaos_onicks[0]=0;
  strcpy(chaos_onicks, nicks);
  chaos_ocount = howManyOfThem(nicks, opBreakp, 0);

  debug4("(chaos.c->flushKick) flusking %d %sops on %s: %s", chaos_ocount, opType, channel, chaos_onicks);

  if (chaos_ocount == 1) strcpy(opString, "o");
  if (chaos_ocount == 2) strcpy(opString, "oo");
  if (chaos_ocount == 3) strcpy(opString, "ooo");
  if (chaos_ocount == 4) strcpy(opString, "o");
  if (chaos_ocount >= 5) strcpy(opString, "oo");

  if (!fastop) {
    if (chaos_ocount > 3) {
      strcpy(opString, "ooo");
      tmpoutput = sortUsers(chaos_onicks, opBreakp);
      strcpy(chaos_onicks, tmpoutput);
      chaos_ocount = howManyOfThem(chaos_onicks, opBreakp, 0);
      chaos_onicks[ident[3]]=0;
      nfree(tmpoutput);
    }
    chaos_markAsPending(channel, chaos_onicks, opBreakp);
    debug1("(chaos.c->flushOp) !fastop, marked as %sopped", opType);
    dprintf(DP_MODE, "MODE %s %s%s %s\n", channel, opType, opString, chaos_onicks);
  } else {
    if (chaos_ocount <= 3) {
      chaos_markAsPending(channel, chaos_onicks, opBreakp);
      debug1("(chaos.c->flushOp) fastop <= 3, marked as %sopped", opType);
      dprintf(DP_MODE, "MODE %s %s%s %s\n", channel, opType, opString, chaos_onicks);
    } else if (chaos_ocount <= 4) {
      strcpy(opNicks1, chaos_onicks);
      opNicks1[ident[1]]=0;
      strcpy(opNicks2, &chaos_onicks[ident[3-2]+1]);
      chaos_markAsPending(channel, opNicks1, opBreakp);
      chaos_markAsPending(channel, opNicks2, opBreakp);
      debug1("(chaos.c->flushOp) fastop <= 4, marked as %sopped", opType);
      dprintf(DP_MODE, "MODE %s %s%s %s\nMODE %s %sooo %s\n", channel, opType, opString, opNicks1, channel, opType, opNicks2);
    } else if (chaos_ocount >= 5) {
      if (chaos_ocount > 5) {
        tmpoutput = sortUsers(chaos_onicks, opBreakp);
        strcpy(chaos_onicks, tmpoutput);
        chaos_ocount = howManyOfThem(chaos_onicks, opBreakp, 0);
        debug2("(chaos.c->flushOp) %d users to %sop, trimming to 5", chaos_ocount, opType);
        chaos_onicks[ident[5]]=0;
        nfree(tmpoutput);
      }
      strcpy(opNicks1, chaos_onicks);
      opNicks1[ident[2]]=0;
      strcpy(opNicks2, &chaos_onicks[ident[2]+1]);
      chaos_markAsPending(channel, opNicks1, opBreakp);
      chaos_markAsPending(channel, opNicks2, opBreakp);
      debug1("(chaos.c->flushOp) fastop <= 5, marked as %sopped", opType);
      dprintf(DP_MODE, "MODE %s %s%s %s\nMODE %s %sooo %s\n", channel, opType, opString, opNicks1, channel, opType, opNicks2);
    }
  }
}

/* END OF: Op section */

/* BEGIN: Other */

/* Check channel, used when i got op */
int checkAgain = 0;
struct chanset_t *lastChan = 0;
void chaos_checkChannel(struct chanset_t *chan) {
  memberlist *m;
  char s[UHOSTLEN];
  struct flag_record fr = { FR_GLOBAL | FR_CHAN, 0, 0, 0, 0, 0 };
  char tkickList[HANDLEN*51 + 1] = "";
  char topList[HANDLEN*51 + 1] = "";
  int opCount = 0, kickCount = 0;

  checkAgain = 0;
  lastChan = 0;
  if (!me_op(chan))
    return;
  /* Okay, sort through who needs to be opped/kicked. */
  for (m = chan->channel.member; m && m->nick[0]; m = m->next) {
    sprintf(s, "%s!%s", m->nick, m->userhost);
    if (!m->user) {
       m->user = get_user_by_host(s);
    }
    if (chan_issplit(m))
      continue; /* Don't check user while netsplit */
    if (match_my_nick(m->nick))
      continue; /* Don't check myself */
    get_user_flagrec(m->user, &fr, chan->dname);
    /* Autoop others when i got an op */
    Context; // To be sure
    if (channel_takeover(chan)) {
      if (glob_bot(fr) && !chan_hasop(m) && (chan_op(fr) || (glob_op(fr) && !chan_deop(fr))) && (channel_autoop(chan) || (glob_autoop(fr) || chan_autoop(fr))) && !(m->flags & SENTOP))
        goto Add2Oplist;
      else if (chan_hasop(m) && !(chan_op(fr) || (glob_op(fr) && !chan_deop(fr))) && !(m->flags & SENTKICK))
        goto Add2KickList;
    } else if (!channel_takeover(chan)) {
      if (glob_bot(fr) && !chan_hasop(m) && (chan_op(fr) || (glob_op(fr) && !chan_deop(fr))) && (channel_autoop(chan) || (glob_autoop(fr) || chan_autoop(fr))) && !(m->flags & SENTOP))
        goto Add2Oplist;
    }
    Add2Oplist:
    if (glob_bot(fr) && !chan_hasop(m) && (chan_op(fr) || (glob_op(fr) && !chan_deop(fr))) && (channel_autoop(chan) || (glob_autoop(fr) || chan_autoop(fr))) && !(m->flags & SENTOP)) {
      if (strlen(topList) < HANDLEN*50) {
        if (topList[0])
          strcat(topList, " ");
        debug1("(chaos.c->checkChannel) Adding %s to oplist", m->nick);
        strcat(topList, m->nick);
        opCount++;
      }
    }
    /* Autokick badusers when i get an op */
    Add2KickList:
    if (channel_takeover(chan)) {
      /* If user isn't valid op add him to tkickList */
      if (chan_hasop(m) && !(chan_op(fr) || (glob_op(fr) && !chan_deop(fr))) && !(m->flags & SENTKICK)) {
        if (strlen(tkickList) < HANDLEN*50) {
          if (tkickList[0])
            strcat(tkickList, ",");
          debug1("(chaos.c->checkChannel) Adding %s to kicklist", m->nick);
          strcat(tkickList, m->nick);
          kickCount++;
        }
      }
    }
  }
  /* Op users from topList */
  if (topList[0] && me_op(chan)) {
    Context; // To be sure
    debug2("(chaos.c->checkChannel) Opping %d users from oplist: %s", opCount, topList);
    if (opCount && (opCount <= 3)) {
      chaos_flushOp(chan->name, topList, "+", 100, 0);
    } else if (opCount > 3) {
      if (!channel_fastop(chan) || channel_fastkick(chan)) {
        chaos_flushOp(chan->name, topList, "+", 100, 0);
      } else if (channel_fastop(chan) && !channel_fastkick(chan)) {
        chaos_flushOp(chan->name, topList, "+", 100, 1);
      }
      if (opCount > 5)
        checkAgain = 1;
    }
  }
  /* Kick users from tkickList */
  if (channel_takeover(chan) && tkickList[0] && me_op(chan)) {
    Context; // To be sure
    debug2("(chaos.c->checkChannel) Kicking %d users from kicklist: %s", kickCount, tkickList);
    if ((kickCount > 0) && (kickCount <= 4)) {
      chaos_flushKick(chan->name, tkickList, "-AUTO-", 100, 0);
    } else if (kickCount >= 5) {
      if (!channel_fastkick(chan) || channel_fastop(chan)) {
        chaos_flushKick(chan->name, tkickList, "-AUTO-", 100, 0);
      } else if (!channel_fastop(chan) && channel_fastkick(chan)) {
        chaos_flushKick(chan->name, tkickList, "-AUTO-", 100, 1);
      }
    }
    if (kickCount > 6)
      checkAgain = 1;
  }

  debug1("(chaos.c->checkChannel) DONE, check again: %d", checkAgain);
  if (checkAgain)
    lastChan = chan;
}

void chaos_checkChannelDelay() {
  static unsigned char chaos_delay;
  if (!lastChan)
    return;
  if (checkAgain) {
    if (chaos_delay >= 3) {
      chaos_delay = 0;
      chaos_checkChannel(lastChan);
    } else {
      chaos_delay++;
      return;
    }
  } else {
    chaos_delay = 0;
  }
}

/* END OF: Other */
