/*
 * snprintf.h
 *   header file for snprintf.c
 *
 * $Id: snprintf.h,v 1.16 2003/11/28 20:11:25 [Xp-AvR] Exp $
 */

#ifndef _EVANGELINE_COMPAT_SNPRINTF_H_
#define _EVANGELINE_COMPAT_SNPRINTF_H_

#include "src/main.h"
#include <stdio.h>

#ifdef BROKEN_SNPRINTF
#  ifdef HAVE_VSNPRINTF
#    undef HAVE_VSNPRINTF
#  endif
#  ifdef HAVE_SNPRINTF
#    undef HAVE_SNPRINTF
#  endif
#endif

#ifndef HAVE_VSNPRINTF
int EvangelineVsnprintf(char *str, size_t count, const char *fmt, va_list ap);
#else
#  define EvangelineVsnprintf vsnprintf
#endif

/* Use the system libraries version of snprintf() if available. Otherwise
 * use our own.
 */
#ifndef HAVE_SNPRINTF
#  ifdef __STDC__
int EvangelineSnprintf(char *str, size_t count, const char *fmt, ...);
#  else
int EvangelineSnprintf();
#  endif
#else
#  define EvangelineSnprintf snprintf
#endif

#endif /* !_EVANGELINE_COMPAT_SNPRINTF_H_ */
