/*
 * compress.h
 *   header file for the zlib compression module
 *
 * $Id: compress.h,v 1.8 (0.5) 2003/12/18 21:33:41 [Xp-AvR] Exp $
 */

#ifndef _COMPRESS_COMPRESS_H
#define _COMPRESS_COMPRESS_H

#define UFF_COMPRESS    0x000008        /* Compress the user file       */

typedef enum {
  COMPF_ERROR,                  /* Compression failed.                  */
  COMPF_SUCCESS                 /* Compression succeeded.               */
} compf_result;

typedef enum {
  COMPF_UNCOMPRESSED,           /* File is uncompressed.                */
  COMPF_COMPRESSED,             /* File is compressed.                  */
  COMPF_FAILED                  /* Could not determine file type.       */
} compf_type;

int uncompress_to_file(char *f_src, char *f_target);
int compress_to_file(char *f_src, char *f_target, int mode_num);
int compress_file(char *filename, int mode_num);
int uncompress_file(char *filename);
int is_compressedfile(char *filename);

#endif /* !_COMPRESS_COMPRESS_H */
