/* xpkeygen.c -- encrypt/decrypt keys generator
 *
 * $Id: xpkeygen.c,v 2.0 2004/07/08 18:29:23 [Xp-AvR] exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static int minKeySize = 16;
static int maxKeySize = 256;

char *convert(char *str);

struct ckeys {
  char bnc1[80];
  char bnc2[512];
  char crc1[80];
  char crc2[512];
  char chanfile1[80];
  char chanfile2[512];
  char usersfile1[80];
  char usersfile2[512];
}; /* ckeys */

unsigned char key() {
  unsigned x, i, j;
  int k;

  i = random() % 0x8FFFFF;
  j = random() % 100;
  x = random() % i;

  for (k = 0; k < j; k++) {
    x = x + i;
    x = x - j;
    x = x ^ i;
  }

  return(x);
}

void makeKey(char *randKey, int keySize)
{
  int k;

  if ((minKeySize <= keySize) && (keySize <= maxKeySize)) {

    for (k = 0; k < keySize; k++) {
      randKey[k] = key();
       if (!((randKey[k] > 96 && randKey[k] < 123) || (randKey[k] > 47 && randKey[k] < 58) || (randKey[k] > 64 && randKey[k] < 91))) // only [A-z] && [0-9]
      k--;
    }
    randKey[keySize] = 0;
  } else {
    printf("Invalid keySize. Must be between %d and %d!\n", minKeySize, maxKeySize);
    exit(0);
  }
}

int main(int argc, char **argv) {
  struct ckeys ck = {"", "", "", "", "", "", "", ""};
  int type = 0;
  char tempkey[512] = "";
  char *tmp, *p;
  FILE *f;

  if (argc > 1) {
    type = 1;
    strcpy(tempkey, argv[1]);
  }

  srandom(time(0));

  if (!type) {
    makeKey(tempkey, 32);
    strcpy(ck.crc1, tempkey);
  }

  /* Userfile Crypt Key */
  tmp = convert(tempkey);
  p = (char *)strchr(tmp, ',');
  tmp[strlen(tmp) - strlen(p)] = 0;
  strcpy(ck.usersfile1, tmp);
  strcpy(ck.crc1, tmp);
  if (p) {
     p++;
  }
  p++;
  strcpy(ck.usersfile2, p);
  strcpy(ck.crc2, p);

  /* Chanfile Crypt Key */
  makeKey(tempkey, 24);
  tmp = convert(tempkey);
  p = (char *)strchr(tmp, ',');
  tmp[strlen(tmp) - strlen(p)] = 0;
  strcpy(ck.chanfile1, tmp);
  if (p) {
     p++;
  }
  p++;
  strcpy(ck.chanfile2, p);

  /* BNC Crypt Key */
  makeKey(tempkey, 24);
  tmp = convert(tempkey);
  p = (char *)strchr(tmp, ',');
  tmp[strlen(tmp) - strlen(p)] = 0;
  strcpy(ck.bnc1, tmp);
  if (p) {
     p++;
  }
  p++;
  strcpy(ck.bnc2, p);

  f = fopen("ckeys.h", "w");
  fprintf(f, "/* ckeys.h -- encrypt/decrypt keys\n");
  fprintf(f, " *\n");
  fprintf(f, " * $Id: ckeys.h,v 2.0 2004/07/08 18:29:23 [Xp-AvR] Exp $\n");
  fprintf(f, " */\n\n");
//  fprintf(f, "#ifndef DISABLE_CRYPT\n");
  fprintf(f, "#define USERFILECK1 \"%s\n", ck.usersfile1);
  fprintf(f, "#define USERFILECK2 %s\n", ck.usersfile2);
  fprintf(f, "#define CRCCK1 \"%s\n", ck.crc1);
  fprintf(f, "#define CRCCK2 %s\n", ck.crc2);
  fprintf(f, "#define CHANFILECK1 \"%s\n", ck.chanfile1);
  fprintf(f, "#define CHANFILECK2 %s\n", ck.chanfile2);
  fprintf(f, "#define BNCCK1 \"%s\n", ck.bnc1);
  fprintf(f, "#define BNCCK2 %s\n", ck.bnc2);
//  fprintf(f, "#endif\n");
  close(f);
  return 0;
}

char tmpstr[512];
char *convert(char *str) {
  int i = 0, j = 0;
  char fe[512] = "", ff[512] = "";

  tmpstr[0] = 0;
  str[strlen(str)] = '\0';

  for(i = 0; i < strlen(str); i++) {
    if (str[i] == '\000') {strcat(fe, ", '\\000'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\001') {strcat(fe, ", '\\001'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\002') {strcat(fe, ", '\\002'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\003') {strcat(fe, ", '\\003'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\004') {strcat(fe, ", '\\004'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\005') {strcat(fe, ", '\\005'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\006') {strcat(fe, ", '\\006'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\007') {strcat(fe, ", '\\007'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\010') {strcat(fe, ", '\\010'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\011') {strcat(fe, ", '\\011'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\013') {strcat(fe, ", '\\013'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\014') {strcat(fe, ", '\\014'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\015') {strcat(fe, ", '\\015'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\016') {strcat(fe, ", '\\016'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\017') {strcat(fe, ", '\\017'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\020') {strcat(fe, ", '\\020'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\021') {strcat(fe, ", '\\021'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\022') {strcat(fe, ", '\\022'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\023') {strcat(fe, ", '\\023'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\024') {strcat(fe, ", '\\024'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\025') {strcat(fe, ", '\\025'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\026') {strcat(fe, ", '\\026'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\027') {strcat(fe, ", '\\027'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\030') {strcat(fe, ", '\\030'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\031') {strcat(fe, ", '\\031'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\032') {strcat(fe, ", '\\032'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\033') {strcat(fe, ", '\\033'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\034') {strcat(fe, ", '\\034'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\035') {strcat(fe, ", '\\035'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\036') {strcat(fe, ", '\\036'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\037') {strcat(fe, ", '\\037'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\040') {strcat(fe, ", '\\040'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\041') {strcat(fe, ", '\\041'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\042') {strcat(fe, ", '\\042'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\043') {strcat(fe, ", '\\043'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\044') {strcat(fe, ", '\\044'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\046') {strcat(fe, ", '\\046'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\047') {strcat(fe, ", '\\047'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\050') {strcat(fe, ", '\\050'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\051') {strcat(fe, ", '\\051'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\052') {strcat(fe, ", '\\052'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\053') {strcat(fe, ", '\\053'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\054') {strcat(fe, ", '\\054'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\055') {strcat(fe, ", '\\055'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\056') {strcat(fe, ", '\\056'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\057') {strcat(fe, ", '\\057'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\060') {strcat(fe, ", '\\060'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\061') {strcat(fe, ", '\\061'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\062') {strcat(fe, ", '\\062'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\063') {strcat(fe, ", '\\063'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\064') {strcat(fe, ", '\\064'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\065') {strcat(fe, ", '\\065'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\066') {strcat(fe, ", '\\066'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\067') {strcat(fe, ", '\\067'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\070') {strcat(fe, ", '\\070'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\071') {strcat(fe, ", '\\071'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\072') {strcat(fe, ", '\\072'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\073') {strcat(fe, ", '\\073'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\074') {strcat(fe, ", '\\074'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\075') {strcat(fe, ", '\\075'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\076') {strcat(fe, ", '\\076'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\077') {strcat(fe, ", '\\077'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\100') {strcat(fe, ", '\\100'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\101') {strcat(fe, ", '\\101'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\102') {strcat(fe, ", '\\102'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\103') {strcat(fe, ", '\\103'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\104') {strcat(fe, ", '\\104'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\105') {strcat(fe, ", '\\105'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\106') {strcat(fe, ", '\\106'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\107') {strcat(fe, ", '\\107'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\110') {strcat(fe, ", '\\110'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\111') {strcat(fe, ", '\\111'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\112') {strcat(fe, ", '\\112'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\113') {strcat(fe, ", '\\113'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\114') {strcat(fe, ", '\\114'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\115') {strcat(fe, ", '\\115'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\116') {strcat(fe, ", '\\116'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\117') {strcat(fe, ", '\\117'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\120') {strcat(fe, ", '\\120'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\121') {strcat(fe, ", '\\121'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\122') {strcat(fe, ", '\\122'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\123') {strcat(fe, ", '\\123'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\124') {strcat(fe, ", '\\124'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\125') {strcat(fe, ", '\\125'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\126') {strcat(fe, ", '\\126'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\127') {strcat(fe, ", '\\127'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\130') {strcat(fe, ", '\\130'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\131') {strcat(fe, ", '\\131'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\132') {strcat(fe, ", '\\132'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\133') {strcat(fe, ", '\\133'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\134') {strcat(fe, ", '\\134'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\135') {strcat(fe, ", '\\135'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\136') {strcat(fe, ", '\\136'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\137') {strcat(fe, ", '\\137'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\140') {strcat(fe, ", '\\140'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\141') {strcat(fe, ", '\\141'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\142') {strcat(fe, ", '\\142'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\143') {strcat(fe, ", '\\143'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\144') {strcat(fe, ", '\\144'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\145') {strcat(fe, ", '\\145'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\146') {strcat(fe, ", '\\146'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\147') {strcat(fe, ", '\\147'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\150') {strcat(fe, ", '\\150'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\151') {strcat(fe, ", '\\151'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\152') {strcat(fe, ", '\\152'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\153') {strcat(fe, ", '\\153'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\154') {strcat(fe, ", '\\154'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\155') {strcat(fe, ", '\\155'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\156') {strcat(fe, ", '\\156'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\157') {strcat(fe, ", '\\157'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\160') {strcat(fe, ", '\\160'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\161') {strcat(fe, ", '\\161'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\162') {strcat(fe, ", '\\162'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\163') {strcat(fe, ", '\\163'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\164') {strcat(fe, ", '\\164'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\165') {strcat(fe, ", '\\165'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\166') {strcat(fe, ", '\\166'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\167') {strcat(fe, ", '\\167'"); strcat(ff, "%c"); j++;}

    if (str[i] == '\170') {strcat(fe, ", '\\170'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\171') {strcat(fe, ", '\\171'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\172') {strcat(fe, ", '\\172'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\173') {strcat(fe, ", '\\173'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\174') {strcat(fe, ", '\\174'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\175') {strcat(fe, ", '\\175'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\176') {strcat(fe, ", '\\176'"); strcat(ff, "%c"); j++;}
    if (str[i] == '\177') {strcat(fe, ", '\\177'"); strcat(ff, "%c"); j++;}
  }

  if(j == strlen(str))
    sprintf(tmpstr, "%s\"%s", ff, fe);

  return (tmpstr);
}
