/*
 * misc.c -- handles:
 *   split() maskhost() dumplots() daysago() days() daysdur() copyfile() movefile() file_readable()
 *   logging things
 *   queueing output for the bot (msg)
 *   resync buffers for sharebots
 *
 * $Id: misc.c,v 1.71 (0.9) 2004/04/17 22:43:44 [Xp-AvR] Exp $
 */

#include "main.h"
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include "chan.h"
#include "tandem.h"
#include "modules.h"
#ifdef HAVE_UNAME
#  include <sys/utsname.h>
#endif
#include "stat.h"

extern struct dcc_t *dcc;
extern struct chanset_t *chanset;
extern char version[], origbotname[], botname[], admin[], network[], ver[],
	    botnetnick[], logfile_suffix[], userfileCryptKey[];
extern int backgrd, use_stderr, dcc_total, keep_all_logs, quick_logs, strict_host;
extern time_t now;
extern Tcl_Interp *interp;


int shtime = 1;                 /* Whether or not to display the time with console output */
log_t *logs = 0;                /* Logfiles */
int max_logs = 5;               /* Current maximum log files */
int max_logsize = 0;            /* Maximum logfile size, 0 for no limit */
int raw_log = 0;                /* Disply output to server to LOG_SERVEROUT */
int conmask = LOG_MODES | LOG_CMDS | LOG_MISC;  /* Console mask */

/* Expected memory usage */
int expmem_misc()
{
  int tot = 0;
  return tot + (max_logs * sizeof(log_t));
}

void init_misc()
{
  static int last = 0;

  if (max_logs < 1)
    max_logs = 1;
  if (logs)
    logs = nrealloc(logs, max_logs * sizeof(log_t));
  else
    logs = nmalloc(max_logs * sizeof(log_t));
  for (; last < max_logs; last++) {
    logs[last].filename = logs[last].chname = NULL;
    logs[last].mask = 0;
    logs[last].f = NULL;
    /* Added by cybah  */
    logs[last].szlast[0] = 0;
    logs[last].repeats = 0;
    /* Added by rtc  */
    logs[last].flags = 0;
  }
}

/* low-level stuff for other modules */
int is_file(const char *s)
{
  struct stat ss;
  int i = stat(s, &ss);

  if (i < 0)
    return 0;
  if ((ss.st_mode & S_IFREG) || (ss.st_mode & S_IFLNK))
    return 1;
  return 0;
}

int EvangelineStrcatn(char *dst, const char *src, size_t max)
{
  size_t tmpmax = 0;

  /* find end of 'dst' */
  while (*dst && max > 0) {
    dst++;
    max--;
  }

  tmpmax = max;

  while (*src && max > 1) {
    *dst++ = *src++;
    max--;
  }

  *dst = 0;

  return tmpmax - max;
}

int my_strcpy(register char *a, register char *b)
{
  register char *c = b;

  while (*b)
    *a++ = *b++;
  *a = *b;
  return b - c;
}

/* Split first word off of rest and put it in first */
void splitc(char *first, char *rest, char divider)
{
  char *p = strchr(rest, divider);

  if (p == NULL) {
    if (first != rest && first)
      first[0] = 0;
    return;
  }
  *p = 0;
  if (first != NULL)
    strcpy(first, rest);
  if (first != rest)
    strcpy(rest, p + 1);
}

void splitcn(char *first, char *rest, char divider, size_t max)
{
  char *p = strchr(rest, divider);

  if (p == NULL) {
    if (first != rest && first)
      first[0] = 0;
    return;
  }
  *p = 0;
  if (first != NULL)
    strncpyz(first, rest, max);
  if (first != rest)
    strcpy(rest, p + 1);
}

char *splitnick(char **blah)
{
  char *p = strchr(*blah, '!'), *q = *blah;

  if (p) {
    *p = 0;
    *blah = p + 1;
    return q;
  }
  return "";
}

void remove_crlf(char **line)
{
  char *p;

  p = strchr(*line, '\n');
  if (p != NULL)
    *p = 0;
  p = strchr(*line, '\r');
  if (p != NULL)
    *p = 0;
}

char *newsplit(char **rest)
{
  register char *o, *r;

  if (!rest)
    return *rest = "";
  o = *rest;
  while (*o == ' ')
    o++;
  r = o;
  while (*o && (*o != ' '))
    o++;
  if (*o)
    *o++ = 0;
  *rest = o;
  return r;
}

/* Convert "abc!user@a.b.host" into "*!user@*.b.host"
 * or "abc!user@1.2.3.4" into "*!user@1.2.3.*"
 * or "abc!user@0:0:0:0:0:ffff:1.2.3.4" into "*!user@0:0:0:0:0:ffff:1.2.3.*"
 * or "abc!user@3ffe:604:2:b02e:6174:7265:6964:6573" into
 *    "*!user@3ffe:604:2:b02e:6174:7265:6964:*"
 */
void _maskhost(const char *s, char *nw, int host)
{
  register const char *p, *q, *e, *f;
  int i;

  *nw++ = '*';
  *nw++ = '!';
  p = (q = strchr(s, '!')) ? q + 1 : s;
  if ((q = strchr(p, '@'))) {
    int fl = 0;

    if ((q - p) > 9) {
      nw[0] = '*';
      p = q - 7;
      i = 1;
    } else
      i = 0;
    while (*p != '@') {
      if (!fl && strchr("~+-^=", *p)) {
        if (strict_host)
          nw[i] = '?';
        else if (!host)
          nw[i] = '*';
        else
          i--;
      } else
        nw[i] = *p;
      fl++;
      p++;
      i++;
    }
    nw[i++] = '@';
    q++;
  } else {
    nw[0] = '*';
    nw[1] = '@';
    i = 2;
    q = s;
  }
  nw += i;
  e = NULL;
  if ((!(p = strchr(q, '.')) || !(e = strchr(p + 1, '.'))) && !strchr(q, ':'))
    strcpy(nw, q);
  else {
    if (e == NULL) {            /* IPv6 address?                */
      const char *mask_str;

      f = strrchr(q, ':');
      if (strchr(f, '.')) {     /* IPv4 wrapped in an IPv6?     */
        f = strrchr(f, '.');
        mask_str = ".*";
      } else                      /* ... no, true IPv6.               */
        mask_str = ":*";
      strncpy(nw, q, f - q);
      nw += (f - q);
      strcpy(nw, mask_str);
    } else {
      for (f = e; *f; f++);
      f--;
      if (*f >= '0' && *f <= '9') {     /* Numeric IP address */
        while (*f != '.')
          f--;
        strncpy(nw, q, f - q);
        nw += (f - q);
        strcpy(nw, ".*");
      } else {                    /* Normal host >= 3 parts */
        /*    a.b.c  -> *.b.c
         *    a.b.c.d ->  *.b.c.d if tld is a country (2 chars)
         *             OR   *.c.d if tld is com/edu/etc (3 chars)
         *    a.b.c.d.e -> *.c.d.e   etc
         */
        const char *x = strchr(e + 1, '.');

        if (!x)
          x = p;
        else if (strchr(x + 1, '.'))
          x = e;
        else if (strlen(x) == 3)
          x = p;
        else
          x = e;
        sprintf(nw, "*%s", x);
      }
    }
  }
}

/* Dump a potentially super-long string of text. */
void dumplots(int idx, const char *prefix, char *data)
{
  char *p = data, *q, *n, c;
  const int max_data_len = 500 - strlen(prefix);

  if (!*data) {
    dprintf(idx, "%s\n", prefix);
    return;
  }
  while (strlen(p) > max_data_len) {
    q = p + max_data_len;
    n = strchr(p, '\n');
    if (n && n < q) {
      *n = 0;
      dprintf(idx, "%s%s\n", prefix, p);
      *n = '\n';
      p = n + 1;
    } else {
      while (*q != ' ' && q != p)
        q--;
      if (q == p)
        q = p + max_data_len;
      c = *q;
      *q = 0;
      dprintf(idx, "%s%s\n", prefix, p);
      *q = c;
      p = q;
      if (c == ' ')
        p++;
    }
  }
  n = strchr(p, '\n');
  while (n) {
    *n = 0;
    dprintf(idx, "%s%s\n", prefix, p);
    *n = '\n';
    p = n + 1;
    n = strchr(p, '\n');
  }
  if (*p)
    dprintf(idx, "%s%s\n", prefix, p);  /* Last trailing bit */
}

/* Convert an interval (in seconds) to one of: "19 days ago", "1 day ago", "18:12" */
void daysago(time_t now, time_t then, char *out)
{
  if (now - then > 86400) {
    int days = (now - then) / 86400;

    sprintf(out, "%d day%s ago", days, (days == 1) ? "" : "s");
    return;
  }
  EvangelineStrftime(out, 6, "%H:%M", localtime(&then));
}

/* Convert an interval (in seconds) to one of: "in 19 days", "in 1 day", "at 18:12" */
void days(time_t now, time_t then, char *out)
{
  if (now - then > 86400) {
    int days = (now - then) / 86400;

    sprintf(out, "in %d day%s", days, (days == 1) ? "" : "s");
    return;
  }
  EvangelineStrftime(out, 9, "at %H:%M", localtime(&now));
}

/* Convert an interval (in seconds) to one of: "for 19 days", "for 1 day", "for 09:10" */
void daysdur(time_t now, time_t then, char *out)
{
  char s[81];
  int hrs, mins;

  if (now - then > 86400) {
    int days = (now - then) / 86400;

    sprintf(out, "for %d day%s", days, (days == 1) ? "" : "s");
    return;
  }
  strcpy(out, "for ");
  now -= then;
  hrs = (int) (now / 3600);
  mins = (int) ((now - (hrs * 3600)) / 60);
  sprintf(s, "%02d:%02d", hrs, mins);
  strcat(out, s);
}

/* Log something: putlog(level,channel_name,format,...); */
void putlog EVANGELINE_VARARGS_DEF(int, arg1)
{
  int i, type, tsl = 0;
  char *format, *chname, s[LOGLINELEN], s1[256], *out, ct[81], *s2, stamp[34];
  va_list va;
  time_t now2 = time(NULL);
  struct tm *t = localtime(&now2);

  type = EVANGELINE_VARARGS_START(int, arg1, va);
  chname = va_arg(va, char *);
  format = va_arg(va, char *);

  t = localtime(&now2);
  if (shtime) {
    EvangelineStrftime(stamp, sizeof(stamp) - 2, LOG_TS, t);
    strcat(stamp, " ");
    tsl = strlen(stamp);
  } else {
    *stamp = '\0';
  }

  out = s + tsl;
  EvangelineVsnprintf(out, LOGLINEMAX - tsl, format, va);
  out[LOGLINEMAX - tsl] = 0;
  if (keep_all_logs) {
    if (!logfile_suffix[0])
      EvangelineStrftime(ct, 12, ".%d%b%Y", t);
    else {
      EvangelineStrftime(ct, 80, logfile_suffix, t);
      ct[80] = 0;
      s2 = ct;
      while (s2[0]) {
        if (s2[0] == ' ')
          s2[0] = '_';
        s2++;
      }
    }
  }
  if (out[0] && shtime) {
    strncpy(s, stamp, tsl);
    out = s;
  }
  strcat(out, "\n");
  if (!use_stderr) {
    for (i = 0; i < max_logs; i++) {
      if ((logs[i].filename != NULL) && (logs[i].mask & type) &&
          ((chname[0] == '*') || (logs[i].chname[0] == '*') ||
           (!rfc_casecmp(chname, logs[i].chname)))) {
        if (logs[i].f == NULL) {
          if (keep_all_logs) {
            EvangelineSnprintf(s1, 256, "%s%s", logs[i].filename, ct);
            logs[i].f = fopen(s1, "a+");
          } else
            logs[i].f = fopen(logs[i].filename, "a+");
        }
        if (logs[i].f != NULL) {
          if (!EvangelineStrcasecmp(out + tsl, logs[i].szlast))
            logs[i].repeats++;
          else {
            if (logs[i].repeats > 0) {
              fprintf(logs[i].f, stamp);
              fprintf(logs[i].f, MISC_LOGREPEAT, logs[i].repeats);
              logs[i].repeats = 0;
            }
            fputs(out, logs[i].f);
            strncpyz(logs[i].szlast, out + tsl, LOGLINEMAX);
          }
        }
      }
    }
  }
  for (i = 0; i < dcc_total; i++) {
    if ((dcc[i].type == &DCC_CHAT) && (dcc[i].u.chat->con_flags & type)) {
      if ((chname[0] == '*') || (dcc[i].u.chat->con_chan[0] == '*') ||
          !rfc_casecmp(chname, dcc[i].u.chat->con_chan)) {
        dprintf(i, "%s", out);
      }
    }
  }
  if (!backgrd)
    dprintf(DP_STDOUT, "%s", out);
  else if ((type & LOG_MISC) && use_stderr) {
    if (shtime)
      out += tsl;
    dprintf(DP_STDERR, "%s", s);
  }
  va_end(va);
}

/* Called as soon as the logfile suffix changes. All logs are closed and the new suffix is stored in `logfile_suffix'. */
void logsuffix_change(char *s)
{
  int i;
  char *s2 = logfile_suffix;

  if (s && s2 && !strcmp(s, s2))
    return;

  debug0("(misc.c->logsuffix_change) Logfile suffix changed. Closing all open logs.");
  strcpy(logfile_suffix, s);
  while (s2[0]) {
    if (s2[0] == ' ')
      s2[0] = '_';
    s2++;
  }
  for (i = 0; i < max_logs; i++) {
    if (logs[i].f) {
      fflush(logs[i].f);
      fclose(logs[i].f);
      logs[i].f = NULL;
    }
  }
}

void check_logsize()
{
  struct stat ss;
  int i;

  char buf[1024];               /* Should be plenty */

  if (!keep_all_logs && max_logsize > 0) {
    for (i = 0; i < max_logs; i++) {
      if (logs[i].filename) {
        if (stat(logs[i].filename, &ss) != 0) {
          break;
        }
        if ((ss.st_size >> 10) > max_logsize) {
          if (logs[i].f) {
            putlog(LOG_MISC, "*", MISC_CLOGS, logs[i].filename, ss.st_size);
            fflush(logs[i].f);
            fclose(logs[i].f);
            logs[i].f = NULL;
          }

          EvangelineSnprintf(buf, sizeof buf, "%s.yesterday", logs[i].filename);
          buf[1023] = 0;
          unlink(buf);
          movefile(logs[i].filename, buf);
        }
      }
    }
  }
}

/* Flush the logfiles to disk */
void flushlogs()
{
  int i;

  if (!logs)
    return;

  for (i = 0; i < max_logs; i++) {
    if (logs[i].f != NULL) {
      if ((logs[i].repeats > 0) && quick_logs) {
        char stamp[33];

        EvangelineStrftime(stamp, sizeof(stamp) - 1, LOG_TS, localtime(&now));
        fprintf(logs[i].f, "%s ", stamp);
        fprintf(logs[i].f, MISC_LOGREPEAT, logs[i].repeats);
        /* Reset repeats */
        logs[i].repeats = 0;
      }
      fflush(logs[i].f);
    }
  }
}

/* Substitute vars in a lang text to dcc chatter */
void sub_lang(int idx, char *text)
{
  char s[1024];
  struct flag_record fr = { FR_GLOBAL | FR_CHAN, 0, 0, 0, 0, 0 };

  get_user_flagrec(dcc[idx].user, &fr, dcc[idx].u.chat->con_chan);
  strncpyz(s, text, sizeof s);
  if (s[strlen(s) - 1] == '\n')
    s[strlen(s) - 1] = 0;
  if (!s[0])
    strcpy(s, " ");
  if (s[0])
    dprintf(idx, "%s\n", s);
}

char *extracthostname(char *hostmask)
{
  char *p = strrchr(hostmask, '@');

  return p ? p + 1 : "";
}

/* Create a string with random letters and digits */
void make_rand_str(char *s, int len)
{
  int j;

  for (j = 0; j < len; j++) {
    if (random() % 3 == 0)
      s[j] = '0' + (random() % 10);
    else
      s[j] = 'a' + (random() % 26);
  }
  s[len] = 0;
}

int oatoi(const char *octal)
{
  register int i;

  if (!*octal)
    return -1;
  for (i = 0; ((*octal >= '0') && (*octal <= '7')); octal++)
    i = (i * 8) + (*octal - '0');
  if (*octal)
    return -1;
  return i;
}

char *str_escape(const char *str, const char div, const char mask)
{
  const int len = strlen(str);
  int buflen = (2 * len), blen = 0;
  char *buf = nmalloc(buflen + 1), *b = buf;
  const char *s;

  if (!buf)
    return NULL;
  for (s = str; *s; s++) {
    if ((buflen - blen) <= 3) {
      buflen = (buflen * 2);
      buf = nrealloc(buf, buflen + 1);
      if (!buf)
        return NULL;
      b = buf + blen;
    }

    if (*s == div || *s == mask) {
      sprintf(b, "%c%02x", mask, *s);
      b += 3;
      blen += 3;
    } else {
      *(b++) = *s;
      blen++;
    }
  }
  *b = 0;
  return buf;
}

char *strchr_unescape(char *str, const char div, register const char esc_char)
{
  char buf[3];
  register char *s, *p;

  buf[2] = 0;
  for (s = p = str; *s; s++, p++) {
    if (*s == esc_char) {       /* Found escape character.              */
      /* Convert code to character. */
      buf[0] = s[1], buf[1] = s[2];
      *p = (unsigned char) strtol(buf, NULL, 16);
      s += 2;
    } else if (*s == div) {
      *p = *s = 0;
      return (s + 1);           /* Found searched for character.        */
    } else
      *p = *s;
  }
  *p = 0;
  return NULL;
}

/* Is every character in a string a digit? */
int str_isdigit(const char *str)
{
  if (!*str)
    return 0;

  for(; *str; ++str) {
    if (!EvangelineIsdigit(*str))
      return 0;
  }
  return 1;
}

void str_unescape(char *str, register const char esc_char)
{
  (void) strchr_unescape(str, 0, esc_char);
}

void kill_bot(char *s1, char *s2)
{
  call_hook(HOOK_DIE);
  chatout("*** %s\n", s1);
  botnet_send_chat(-1, botnetnick, s1);
  botnet_send_bye();
  write_userfile(-1, userfileCryptKey);
  fatal(s2, 0);
}

/* Copy a file from one place to another (possibly erasing old copy).
 *
 * returns:  0 if OK
 *           1 if can't open original file
 *           2 if can't open new file
 *           3 if original file isn't normal
 *           4 if ran out of disk space
 */
int copyfile(char *oldpath, char *newpath)
{
  int fi, fo, x;
  char buf[512];
  struct stat st;

#ifndef CYGWIN_HACKS
  fi = open(oldpath, O_RDONLY, 0);
#else
  fi = open(oldpath, O_RDONLY | O_BINARY, 0);
#endif
  if (fi < 0)
    return 1;
  fstat(fi, &st);
  if (!(st.st_mode & S_IFREG))
    return 3;
  fo = creat(newpath, (int) (st.st_mode & 0777));
  if (fo < 0) {
    close(fi);
    return 2;
  }
  for (x = 1; x > 0;) {
    x = read(fi, buf, 512);
    if (x > 0) {
      if (write(fo, buf, x) < x) {      /* Couldn't write */
        close(fo);
        close(fi);
        unlink(newpath);
        return 4;
      }
    }
  }
#ifdef HAVE_FSYNC
  fsync(fo);
#endif /* HAVE_FSYNC */
  close(fo);
  close(fi);
  return 0;
}

int movefile(char *oldpath, char *newpath)
{
  int ret;

#ifdef HAVE_RENAME
  if (!rename(oldpath, newpath))
    return 0;
#endif /* HAVE_RENAME */

  ret = copyfile(oldpath, newpath);
  if (!ret)
    unlink(oldpath);
  return ret;
}

int file_readable(char *file)
{
  FILE *fp;

  if (!(fp = fopen(file, "r")))
    return 0;

  fclose(fp);
  return 1;
}
