/*
 * modules.h
 *   support for modules in Evangeline
 *
 * $Id: modules.h,v 1.13 2003/11/28 21:25:40 [Xp-AvR] Exp $
 */

#ifndef _EVANGELINE_MODULE_H
#define _EVANGELINE_MODULE_H

#include "modules/modvals.h"

#ifndef MAKING_NUMMODS

void do_module_report(int, int, char *);

int module_register(char *name, Function* funcs, int major, int minor);
const char *module_load(char *module_name);
char *module_unload(char *module_name, char *nick);
module_entry *module_find(char *name, int, int);
Function *module_depend(char *, char *, int major, int minor);
int module_undepend(char *);
void *mod_malloc(int size, const char *modname, const char *filename, int line);
void *mod_realloc(void *ptr, int size, const char *modname,
                  const char *filename, int line);
void mod_free(void *ptr, const char *modname, const char *filename, int line);
void add_hook(int hook_num, Function func);
void del_hook(int hook_num, Function func);
void *get_next_hook(int hook_num, void *func);
extern struct hook_entry {
  struct hook_entry *next;
  int (*func) ();
} *hook_list[REAL_HOOKS];

#define call_hook(x) do {                                       \
        register struct hook_entry *p, *pn;                     \
                                                                \
        for (p = hook_list[x]; p; p = pn) {                     \
                pn = p->next;                                   \
                p->func();                                      \
        }                                                       \
} while (0)
int call_hook_cccc(int, char *, char *, char *, char *);

#endif

typedef struct _dependancy {
  struct _module_entry *needed;
  struct _module_entry *needing;
  struct _dependancy *next;
  int major;
  int minor;
} dependancy;
extern dependancy *dependancy_list;

#endif /* _EVANGELINE_MODULE_H */
