/*
 * Copyright (C) 2000,2001  Florian Sander
 *
 * $Id: seentree.c (1.1.0) for AversE-XP v1.0+ 2003/12/06 [Xp-AvR] Exp $
 */

static struct generic_binary_tree seentree;

static void seentree_init();
static int seentree_expmem();
static void seentree_free();
static int compareseens(void *, void *);
static int expmemseen(void *);
static void add_seen(int, char *, char *, char *, char *, time_t, int);
static void freeseen(void *);
static seendat *findseen(char *);
static void wildmatch_seens(char *, char *, int);
static void process_wildmatch_seens(void *);
static void write_seen_tree(void *);
static void purge_seen_tree(void *);
static int count_seens();
static void _count_seens(void *);


static void seentree_init()
{
  seentree.root = NULL;
  seentree.comparedata = compareseens;
  seentree.expmemdata = expmemseen;
  seentree.freedata = freeseen;
}

static int seentree_expmem()
{
  return btree_expmem(&seentree);
}

static void seentree_free()
{
  btree_freetree(&seentree);
  seentree.root = NULL;
}

static int compareseens(void *first, void *second)
{
  return rfc_casecmp(((seendat *) first)->nick, ((seendat *) second)->nick);
}

static void add_seen(int type, char *nick, char *host, char *chan, char *msg, time_t when, int spent)
{
  seendat *newseen;

  newseen = nmalloc(sizeof(seendat));
  newseen->type = type;
  newseen->nick = nmalloc(strlen(nick) + 1);
  strcpy(newseen->nick, nick);
  newseen->host = nmalloc(strlen(host) + 1);
  strcpy(newseen->host, host);
  newseen->chan = nmalloc(strlen(chan) + 1);
  strcpy(newseen->chan, chan);
  newseen->msg = nmalloc(strlen(msg) + 1);
  strcpy(newseen->msg, msg);
  newseen->when = when;
  newseen->spent = spent;
  btree_add(&seentree, newseen);
}

static void freeseen(void *what)
{
  seendat *s = (seendat *) what;

  Assert(s);
  Assert(s->nick);
  Assert(s->host);
  Assert(s->chan);
  Assert(s->msg);

  nfree(s->nick);
  nfree(s->host);
  nfree(s->chan);
  nfree(s->msg);
  nfree(s);
}

static int expmemseen(void *what)
{
  int size = 0;
  seendat *d = (seendat *) what;

  size += sizeof(seendat);
  size += strlen(d->nick) + 1;
  size += strlen(d->host) + 1;
  size += strlen(d->chan) + 1;
  size += strlen(d->msg) + 1;
  return size;
}

seendat findseen_temp;
static seendat *findseen(char *nick)
{
  findseen_temp.nick = nick;
  return btree_get(&seentree, &findseen_temp);
}

static char *wildmatch_host, *wildmatch_mask;
int wildmatch_wild;
static void wildmatch_seens(char *host, char *mask, int wild)
{
  wildmatch_host = host;
  wildmatch_mask = mask;
  wildmatch_wild = wild;
  btree_getall(&seentree, process_wildmatch_seens);
}

/* gets called from the binary tree for each existing item. */
static void process_wildmatch_seens(void *data)
{
  seendat *s = (seendat *) data;

  if ((numresults > max_matches) && (max_matches > 0))
    return;
  if (!wildmatch_wild) {
    if (wild_match(wildmatch_host, s->host))
      add_seenresult(s);
  } else {
    temp_wildmatch_host = my_realloc(temp_wildmatch_host, strlen(s->nick) + 1 + strlen(s->host) + 1);
    strcpy(temp_wildmatch_host, s->nick);
    strcat(temp_wildmatch_host, "!");
    strcat(temp_wildmatch_host, s->host);
    if (wild_match(wildmatch_mask, s->nick) || wild_match(wildmatch_mask, temp_wildmatch_host))
      add_seenresult(s);
  }
}

/* write seendata in the datafile */
FILE *write_seen_tree_target;
static void write_seen_tree(void *data)
{
  seendat *node = (seendat *) data;

  fprintf(write_seen_tree_target, "! %s %s %s %d %lu %d %s\n", node->nick,
          node->host, node->chan, node->type, node->when, node->spent,
          node->msg);
}

static void purge_seen_tree(void *data)
{
  seendat *node = (seendat *) data;

  if ((now - node->when) > (expire_seens * 86400)) {
    debug1("seen data for %s has expired.", node->nick);
    btree_remove(&seentree, node);
  }
}

/* counts the number of nicks in the database */
static int count_seens_temp;
static int count_seens()
{
  count_seens_temp = 0;
  btree_getall(&seentree, _count_seens);
  return count_seens_temp;
}

static void _count_seens(void *node)
{
  count_seens_temp++;
}

static int tcl_killseen STDVAR
{
  Context;
  BADARGS(2, 2, " nick");
  findseen_temp.nick = argv[1];
  btree_remove(&seentree, &findseen_temp);
  return TCL_OK;
}

static tcl_cmds seendebugtcls[] =
{
  {"killseen", tcl_killseen},
  {0, 0}
};
