/*
 * Copyright (C) 2000,2001  Florian Sander
 *
 * $Id: slang_duration.c (1.1.0) for AversE-XP v1.0+ 2003/12/06 [Xp-AvR] Exp $
 */

#define DURATIONS 13

struct slang_duration {
  char *durs[DURATIONS];
};

static struct slang_duration *slang_duration_add(struct slang_duration *where, int idx, char *text)
{
  int i;

  if ((idx < 0) || (idx >= DURATIONS)) {
    putlog(LOG_MISC, "*", "Warning: Invalid duration index \"%d\".", idx);
    return where;
  }
  debug2("Adding duration[%d]: %s", idx, text);
  if (!where) {
    where = nmalloc(sizeof(struct slang_duration));
    for (i = 0; i < DURATIONS; i++)
      where->durs[i] = NULL;
  }
  if (where->durs[idx])
    nfree(where->durs[idx]);
  where->durs[idx] = nmalloc(strlen(text) + 1);
  strcpy(where->durs[idx], text);
  return where;
}

static int slang_duration_expmem(struct slang_duration *what)
{
  int i, size = 0;

  if (!what)
    return 0;
  size += sizeof(struct slang_duration);
  for (i = 0; i < DURATIONS; i++)
    if (what->durs[i])
      size += strlen(what->durs[i]) + 1;
  return size;
}

static void slang_duration_free(struct slang_duration *what)
{
  int i;

  if (what) {
    for (i = 0; i < DURATIONS; i++)
      if (what->durs[i])
        nfree(what->durs[i]);
    nfree(what);
  }
}

static char *slang_duration_get(struct slang_duration *where, int idx)
{
  if (!where) {
    debug0("no where");
    return NULL;
  }
  if ((idx < 0) || (idx >= DURATIONS)) {
    debug1("invalid duration index: %d", idx);
    return NULL;
  }
  return where->durs[idx];
}
