/*
 * Copyright (C) 2000,2001  Florian Sander
 *
 * $Id: slang_ids.c (1.1.0) for AversE-XP v1.0+ 2003/12/06 [Xp-AvR] Exp $
 */

struct slang_id {
  struct slang_id *next;
  int id;
  struct slang_multitext *mtext;
};

static struct slang_id* slang_id_add(struct slang_id *, int, char *);
static int slang_id_expmem(struct slang_id *);
static void slang_id_free(struct slang_id *);
static char *slang_id_get(struct slang_id *, int);

static struct slang_id* slang_id_add(struct slang_id *where, int id, char *text)
{
  struct slang_id *newitem;

  newitem = NULL;
  if (where) {
    for (newitem = where; newitem; newitem = newitem->next)
      if (newitem->id == id)
        break;
  }
  if (!newitem) {
    newitem = nmalloc(sizeof(struct slang_id));
    newitem->next = NULL;
    newitem->id = id;
    newitem->mtext = NULL;
    if (where)
      newitem->next = where;
    else
      newitem->next = NULL;
    where = newitem;
  }
  newitem->mtext = slang_mtext_add(newitem->mtext, text);
  return where;
}

static int slang_id_expmem(struct slang_id *what)
{
  int size = 0;

  for (; what; what = what->next) {
    size += sizeof(struct slang_id);
    size += slang_multitext_expmem(what->mtext);
  }
  return size;
}

static void slang_id_free(struct slang_id *what)
{
  struct slang_id *next;

  while (what) {
    next = what->next;
    slang_multitext_free(what->mtext);
    nfree(what);
    what = next;
  }
}

static char *slang_id_get(struct slang_id *where, int i)
{
  while (where) {
    if (where->id == i)
      return slang_multitext_getrandomtext(where->mtext);
    where = where->next;
  }
  return NULL;
}

#ifndef SLANG_NOGETALL
static char *slang_id_get_first(struct slang_id *where, int id)
{
  while (where) {
    if (where->id == id) {
      return slang_multitext_get_first(where->mtext);
    }
    where = where->next;
  }
  return NULL;
}

static char *slang_id_get_next()
{
  return slang_multitext_get_next();
}
#endif
