/*
 * Copyright (C) 2000,2001  Florian Sander
 *
 * $Id: tclcmds.c (1.1.0) for AversE-XP v1.0+ 2003/12/06 [Xp-AvR] Exp $
 */

static int tcl_setchanseenlang STDVAR
{
  Context;
  BADARGS(3, 3, " channel language");
  chanlangs = slang_chanlang_add(chanlangs, argv[1], argv[2]);
  return TCL_OK;
}

static int tcl_loadseenslang STDVAR
{
  char *shortname, *longname, *filename;
  struct slang_header *slang;

  Context;
  BADARGS(4, 4, " language description langfile");
  shortname = argv[1];
  longname = argv[2];
  filename = argv[3];
  coreslangs = slang_create(coreslangs, shortname, longname);
  slang = slang_find(coreslangs, shortname);
  Assert(slang);
  if (!slang_load(slang, filename)) {
    Tcl_AppendResult(irp, "Couldn't open seenslang file!!!", NULL);
    return TCL_ERROR;
  }
  return TCL_OK;
}

static tcl_cmds gseentcls[] =
{
  {"loadseenslang", tcl_loadseenslang},
  {"setchanseenslang", tcl_setchanseenlang},
  {0, 0}
};
