/*
 * Copyright (C) 2000,2001  Florian Sander
 *
 * $Id: pubcmds.c (1.3.2) for AversE-XP v1.0+ 2003/12/06 [Xp-AvR] Exp $
 */

static int nopubstats(char *chan)
{
  if (!chan) {
    debug0("WARNING: nopubstats() called with NULL pointer");
    return 1;
  }
  if (ngetudef("nopubstats", chan))
    return 1;
  return 0;
}

static int quietstats(char *chan)
{
  if (!chan) {
    debug0("WARNING: quietstats() called with NULL pointer");
    return 1;
  }
  if (ngetudef("quietstats", chan))
    return 1;
  return 0;
}

static int pub_top10(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! top10 %s", nick, hand, text);
  tell_top(channel, channel, nick, text, 1, 10, 0);
  return 1;
}

static int pub_top20(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! top20 %s", nick, hand, text);
  tell_top(channel, channel, nick, text, 11, 20, 0);
  return 1;
}

static int pub_ttop10(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! ttop10 %s", nick, hand, text);
  tell_top(channel, channel, nick, text, 1, 10, 1);
  return 1;
}

static int pub_ttop20(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! ttop20 %s", nick, hand, text);
  tell_top(channel, channel, nick, text, 11, 20, 1);
  return 1;
}

static void tell_top(char *channel, char *dest, char *nick, char *type, int from, int to, int today)
{
  char t[50], *result, *tosend, *slang, *slangtype;
  int i, ti, pi;
  struct stats_global *l;
  struct stats_local *ll;
  struct chanset_t *chan;

  Context;
  filt(type);
  if (stat_flood())
    return;
  if (!strcasecmp(channel, dest)) {
    chan = findchan_by_dname(dest);
    if (chan)
      dest = chan->name;
  }
  l = findglobstats(channel);
  if (!l) {
    debug1("StatMod: Can't do topx for %s, no such entry in linked list", channel);
    return;
  }
  if (!strncasecmp(type, "word ", 5)) {
    tell_top_word(channel, dest, nick, type, from, to, l);
    return;
  }
  if (!type[0] || (strlen(type) > 45))
    strcpy(t, "words");
  else
    strcpy(t, type);
  ti = slangtypetoi(t);
  setslglobs(l->chan, l->peak[today], 0, l->started);
  if ((ti < 0) && (ti != T_WPL) && (ti != T_IDLE)) {
    slang = SLNOSUCHTYPE;
    if (quietstats(dest)) {
      tosend = nmalloc(15 + strlen(nick) + strlen(slang) + 1);
      sprintf(tosend, "NOTICE %s :%s\n", nick, slang);
    } else {
      tosend = nmalloc(16 + strlen(dest) + strlen(slang) + 1);
      sprintf(tosend, "PRIVMSG %s :%s\n", dest, slang);
    }
    dprintf(DP_HELP, "%s", tosend);
    nfree(tosend);
    return;
  }
  sortstats(l, ti, today);
  slglobint = to;
  slang = getslang(1001 + today);
  slangtype = getslangtype(t);
  result = nmalloc(strlen(slang) + strlen(slangtype) + 1);
  sprintf(result, slang, slangtype);
  i = 1;
  if (ti < 0)
    pi = (ti * -1) + (TOTAL_TYPES - 1);
  else
    pi = ti;
  for (ll = l->slocal[today][pi]; ll; ll = ll->snext[today][pi]) {
    if (!listsuser(ll, channel))
      continue;
    if ((ti >= 0) && !ll->values[today][ti])
      break;
    if ((i >= from) && (i <= to)) {
      if (ti >= 0) {
        result = nrealloc(result, strlen(result) + 10 + 5 + strlen(ll->user) + 10 + 1);
        sprintf(result, "%s %d. %s(%ld)", result, i, ll->user, ll->values[today][ti]);
      } else if (ti == T_WPL) {
        result = nrealloc(result, strlen(result) + 10 + 5 + strlen(ll->user) + 10 + 1);
        if (ll->values[today][T_LINES])
          sprintf(result, "%s %d. %s(%.2f)", result, i, ll->user, (float) ll->values[today][T_WORDS] / (float) ll->values[today][T_LINES]);
        else
          sprintf(result, "%s %d. %s(0)", result, i, ll->user);
      } else if (ti == T_IDLE) {
        result = nrealloc(result, strlen(result) + 10 + 5 + strlen(ll->user) + 10 + 1);
        if (ll->values[today][T_LINES])
          sprintf(result, "%s %d. %s(%.2f)", result, i, ll->user, (float) ll->values[today][T_MINUTES] / (float) ll->values[today][T_LINES]);
        else
          sprintf(result, "%s %d. %s(0)", result, i, ll->user);
      } else {
        result = nrealloc(result, strlen(result) + 11 + 10 + 1);
        sprintf(result, "%s ERROR (%d)", result, ti);
      }
    }
    i++;
  }
  if (quietstats(dest)) {
    tosend = nmalloc(12 + strlen(nick) + strlen(result) + 1);
    sprintf(tosend, "NOTICE %s :%s\n", nick, result);
  } else {
    tosend = nmalloc(13 + strlen(dest) + strlen(result) + 1);
    sprintf(tosend, "PRIVMSG %s :%s\n", dest, result);
  }
  dprintf(DP_HELP, "%s", tosend);
  nfree(tosend);
  nfree(result);
  Context;
}

static void tell_top_word(char *channel, char *dest, char *nick, char *type, int from, int to, globstats *gs)
{
  locstats *e;
  char *result, *tosend, *slang;
  int i = 1, itype;

  Context;
  newsplit(&type);
  strlower(type);
  setword(gs, type);
  sortstats(gs, T_WORDS, 1);
  slglobint = to;
  setslglobs(gs->chan, gs->peak[S_TODAY], 0, gs->started);
  slang = SLTOPWORD;
  result = nmalloc(strlen(slang) + strlen(type) + 1);
  sprintf(result, slang, type);
  itype = (T_WORDS * (-1)) + TOTAL_TYPES - 1;
  for (e = gs->slocal[S_TODAY][itype]; e; e = e->snext[S_TODAY][itype]) {
    if (!listsuser(e, channel))
      continue;
    if ((i > to) || !e->word)
      break;
    if (i >= from) {
      result = nrealloc(result, strlen(result) + 13 + 10 + strlen(e->user) + 10 + 1);
      sprintf(result, "%s %d. %s(%d)", result, i, e->user, e->word->nr);
    }
    i++;
  }
  if (quietstats(dest)) {
    tosend = nmalloc(15 + strlen(nick) + strlen(result) + 1);
    sprintf(tosend, "NOTICE %s :%s\n", nick, result);
  } else {
    tosend = nmalloc(16 + strlen(dest) + strlen(result) + 1);
    sprintf(tosend, "PRIVMSG %s :%s\n", dest, result);
  }
  dprintf(DP_HELP, "%s", tosend);
  nfree(result);
  nfree(tosend);
  Context;
}

static int pub_place(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! place %s", nick, hand, text);
  tell_place(nick, channel, hand, channel, text, S_TOTAL);
  Context;
  return 1;
}

static int pub_tplace(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! tplace %s", nick, hand, text);
  tell_place(nick, channel, hand, channel, text, S_TODAY);
  Context;
  return 1;
}

static void tell_place(char *nick, char *dest, char *hand, char *channel, char *text, int today)
{
  globstats *gs;
  locstats *ls;
  struct stats_memberlist *m;
  struct stats_userlist *su;
  struct userrec *u;
  char *who, *slang;
  int place = 0;
  int itype;
  struct chanset_t *chan;

  Context;
  if (stat_flood())
    return;
  m = NULL;
  u = NULL;
  su = NULL;
  who = slang = NULL;
  gs = findglobstats(channel);
  setslglobs(channel, 0, countstatmembers(gs), 0);
  if (!strcasecmp(channel, dest)) {
    chan = findchan_by_dname(dest);
    if (chan)
      dest = chan->name;
  }
  if (!text[0]) {
    itype = T_WORDS;
  } else {
    itype = slangtypetoi(text);
  }
  if (itype != T_ERROR) {
    if (use_userfile) {
      who = nmalloc(strlen(hand) + 1);
      strcpy(who, hand);
    } else {
      m = nick2suser(nick, channel);
      if (m && m->user) {
        who = nmalloc(strlen(m->user->user) + 1);
        strcpy(who, m->user->user);
      } else {
        who = nmalloc(2);
        strcpy(who, "*");
      }
    }
    if (who[0] == '*') {
      setslnick(nick);
      if (quietstats(dest)) {
        dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTYOU);
      } else {
        dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTYOU);
      }
      if (who)
        nfree(who);
      return;
    }
  } else {
    itype = T_WORDS;
    if (use_userfile) {
      u = get_user_by_handle(userlist, text);
      if (u) {
        who = nmalloc(strlen(u->handle) + 1);
        strcpy(who, u->handle);
      } else {
        setslnick(text);
        if (quietstats(dest)) {
          dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
        } else {
          dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
        }
        Assert(!who);
        return;
      }
    } else {
      m = nick2suser(text, channel);
      if (m && m->user) {
        who = nmalloc(strlen(m->user->user) + 1);
        strcpy(who, m->user->user);
      } else {
        su = findsuser_by_name(text);
        if (su) {
          who = nmalloc(strlen(su->user) + 1);
          strcpy(who, su->user);
        } else {
          setslnick(text);
          if (quietstats(dest)) {
            dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
          } else {
            dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
          }
          Assert(!who);
          return;
        }
      }
    }
  }
  if (!gs) {
    Assert(who);
    nfree(who);
    debug1("Stats.mod: Couldn't exec !place, I don't have any statistics in %s.", channel);
    return;
  }
  sortstats(gs, itype, today);
  if (itype < 0)
    itype = (TOTAL_TYPES - 1) + (itype * -1);
  for (ls = gs->slocal[today][itype]; ls; ls = ls->snext[today][itype]) {
    if (!listsuser(ls, channel))
      continue;
    place++;
    if (!rfc_casecmp(who, ls->user))
      break;
  }
  if (!ls) {
    setslnick(who);
    if (quietstats(dest)) {
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
    } else {
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
    }
  } else {
    setslnick(who);
    slglobint = place;
    slang = getslang(1012 + today);
    if (quietstats(dest)) {
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, slang);
    } else {
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, slang);
    }
  }
  Assert(who);
  nfree(who);
  Context;
}

static int pub_stat(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! stat %s", nick, hand, text);
  tell_stat(nick, channel, hand, channel, text, S_TOTAL);
  Context;
  return 1;
}

static int pub_tstat(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! tstat %s", nick, hand, text);
  tell_stat(nick, channel, hand, channel, text, S_TODAY);
  Context;
  return 1;
}

static void tell_stat(char *nick, char *dest, char *hand, char *channel, char *text, int today)
{
  locstats *ls;
  char *who, *tosend, what[128], *pwhat, *type, *dur, *stmp;
  int itype, first;
  struct stats_memberlist *m;
  struct userrec *u;
  struct stats_userlist *su;
  struct chanset_t *chan;

  Context;
  if (stat_flood())
    return;
  who = tosend = type = dur = NULL;
  setslglobs(channel, 0, 0, 0);
  if (!strcasecmp(channel, dest)) {
    chan = findchan_by_dname(dest);
    if (chan)
      dest = chan->name;
  }
  if (text[0] == 0) {
    if (use_userfile) {
      who = nmalloc(strlen(hand) + 1);
      strcpy(who, hand);
    } else {
      m = nick2suser(nick, channel);
      if (m && m->user) {
        who = nmalloc(strlen(m->user->user) + 1);
        strcpy(who, m->user->user);
      } else {
        who = nmalloc(2);
        strcpy(who, "*");
      }
    }
  } else {
    if (use_userfile) {
      u = get_user_by_handle(userlist, text);
      if (u) {
        who = nmalloc(strlen(u->handle) + 1);
        strcpy(who, u->handle);
      } else {
        setslnick(text);
        if (quietstats(dest)) {
          dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
        } else {
          dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
        }
        Assert(!who);
        return;
      }
    } else {
      m = nick2suser(text, channel);
      if (m && m->user) {
        who = nmalloc(strlen(m->user->user) + 1);
        strcpy(who, m->user->user);
      } else {
        su = findsuser_by_name(text);
        if (su) {
          who = nmalloc(strlen(su->user) + 1);
          strcpy(who, su->user);
        } else {
          setslnick(text);
          if (quietstats(dest)) {
            dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
          } else {
            dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
          }
          Assert(!who);
          return;
        }
      }
    }
  }
  setslglobs(channel, 0, 0, 0);
  if (who[0] == '*') {
    setslnick(nick);
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTYOU);
    else
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTYOU);
    nfree(who);
    return;
  }
  ls = findlocstats(channel, who);
  if (!ls) {
    setslnick(who);
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
    else
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
  } else {
    if (quietstats(dest)) {
      tosend = nmalloc(14 + strlen(nick) + strlen(who) + 1);
      sprintf(tosend, "NOTICE %s :%s:", nick, who);
    } else {
      tosend = nmalloc(15 + strlen(dest) + strlen(who) + 1);
      sprintf(tosend, "PRIVMSG %s :%s:", dest, who);
    }
    what[0] = 0;
    pwhat = what;
    strncpy(pwhat, stat_reply, 127);
    pwhat[127] = 0;
    first = 1;
    while (strlen(pwhat) > 0) {
      type = newsplit(&pwhat);
      itype = typetoi(type);
      if ((itype < 0) && (itype != T_WPL) && (itype != T_IDLE))
        continue;
      if (!first) {
        tosend = nrealloc(tosend, strlen(tosend) + 1 + 1);
        strcat(tosend, ",");
      } else {
        first = 0;
      }
      if (itype == T_MINUTES) {
        dur = stats_duration(ls->values[today][T_MINUTES] * 60);
        stmp = getslangtype("minutes");
        tosend = nrealloc(tosend, strlen(tosend) + 3 + strlen(stmp) + strlen(dur) + 1);
        sprintf(tosend, "%s %s: %s", tosend, stmp, dur);
      } else if (itype >= 0) {
        stmp = getslangtype(type);
        tosend = nrealloc(tosend, 8 + strlen(tosend) + 10 + strlen(stmp));
        sprintf(tosend, "%s %ld %s", tosend, ls->values[today][itype], stmp);
      } else if ((itype == T_WPL) && (ls->values[today][T_LINES] != 0)) {
        stmp = getslangtype("wpl");
        tosend = nrealloc(tosend, strlen(tosend) + 2 + 10 + strlen(stmp) + 1);
        sprintf(tosend, "%s %.2f %s", tosend, (float) ls->values[today][T_WORDS] / (float) ls->values[today][T_LINES], stmp);
      } else if ((itype == T_IDLE) && (ls->values[today][T_LINES] != 0)) {
        stmp = getslangtype("idle");
        tosend = nrealloc(tosend, strlen(tosend) + 2 + 10 + strlen(stmp) + 1);
        sprintf(tosend, "%s %.2f %s", tosend, (float) ls->values[today][T_MINUTES] / (float) ls->values[today][T_LINES], stmp);
      }
    }
    dprintf(DP_HELP, "%s.\n", tosend);
    nfree(tosend);
  }
  nfree(who);
  Context;
}

static int pub_wordstats(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! wordstats %s", nick, hand, text);
  tell_wordstats(nick, channel, hand, channel, text);
  Context;
  return 0;
}

static void tell_wordstats(char *nick, char *dest, char *hand, char *channel, char *text)
{
  locstats *ls;
  wordstats *ws;
  char *who, *tosend, *slang;
  int i;
  struct chanset_t *chan;

  Context;
  filt(text);
  if (stat_flood())
    return;
  if (!strcasecmp(channel, dest)) {
    chan = findchan_by_dname(dest);
    if (chan)
      dest = chan->name;
  }
  if (text[0] == 0) {
    who = nmalloc(strlen(hand) + 1);
    strcpy(who, hand);
  } else {
    who = nmalloc(strlen(text) + 1);
    strcpy(who, text);
  }
  setslglobs(channel, 0, 0, 0);
  if (who[0] == '*') {
    setslnick(nick);
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTYOU);
    else
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTYOU);
    nfree(who);
    return;
  }
  ls = findlocstats(channel, who);
  if (!ls) {
    setslnick(who);
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOSTATSABOUTSOMEONE);
    else
      dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOSTATSABOUTSOMEONE);
  } else {
    slgloblocstats = ls;
    if (!ls->words) {
      setslnick(who);
      if (quietstats(dest))
        dprintf(DP_HELP, "NOTICE %s :%s\n", nick, SLNOWORDSTATS);
      else
        dprintf(DP_HELP, "PRIVMSG %s :%s\n", dest, SLNOWORDSTATS);
    } else {
      slang = SLUSERSMOSTUSEDWORDS;
      if (quietstats(dest)) {
        tosend = nmalloc(13 + strlen(nick) + strlen(slang) + 1);
        sprintf(tosend, "NOTICE %s :%s", nick, slang);
      } else {
        tosend = nmalloc(14 + strlen(dest) + strlen(slang) + 1);
        sprintf(tosend, "PRIVMSG %s :%s", dest, slang);
      }
      i = 0;
      sortwordstats(ls, NULL);
      ws = ls->words;
      while (ws && (i < 10)) {
        i++;
        tosend = nrealloc(tosend, 14 + strlen(tosend) + 5 + strlen(ws->word) + 10 + 1);
        sprintf(tosend, "%s %d. %s (%d)", tosend, i, ws->word, ws->nr);
        ws = ws->next;
      }
      dprintf(DP_HELP, "%s\n", tosend);
      nfree(tosend);
    }
  }
  nfree(who);
  Context;
}

static int pub_topwords(char *nick, char *host, char *hand,
        char *channel, char *text)
{
  Context;
  if (nopubstats(channel))
    return 1;
  putlog(LOG_CMDS, channel, "<<%s>> !%s! topwords %s", nick, hand, text);
  tell_topwords(nick, channel, hand, channel);
  Context;
  return 0;
}

static void tell_topwords(char *nick, char *dest, char *hand, char *channel)
{
  globstats *gs;
  wordstats *ws;
  char *tosend, *slang;
  int i;
  struct chanset_t *chan;

  Context;
  if (stat_flood())
    return;
  if (!strcasecmp(channel, dest)) {
    chan = findchan_by_dname(dest);
    if (chan)
      dest = chan->name;
  }
  gs = findglobstats(channel);
  if (!gs) {
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :I don't have any stats in %s\n", nick, channel);
    else
      dprintf(DP_HELP, "PRIVMSG %s :%s, I don't have any stats in %s\n", dest, nick, channel);
    return;
  }
  do_globwordstats(gs);
  ws = gs->words;
  if (!ws) {
    if (quietstats(dest))
      dprintf(DP_HELP, "NOTICE %s :I don't have any wordstats in %s\n", nick, channel);
    else
      dprintf(DP_HELP, "PRIVMSG %s :I don't have any wordstats in %s\n", dest, channel);
    return;
  }
  setslglobs(gs->chan, gs->peak[S_TODAY], 0, gs->started);
  setslnick(nick);
  slang = SLCHANSMOSTUSEDWORDS;
  if (quietstats(dest)) {
    tosend = nmalloc(13 + strlen(nick) + strlen(slang) + 1);
    sprintf(tosend, "NOTICE %s :%s", nick, slang);
  } else {
    tosend = nmalloc(14 + strlen(dest) + strlen(slang) + 1);
    sprintf(tosend, "PRIVMSG %s :%s", dest, slang);
  }
  i = 0;
  while (ws && (i < 10)) {
    i++;
    tosend = nrealloc(tosend, 14 + strlen(tosend) + 5 + strlen(ws->word) + 10);
    sprintf(tosend, "%s %d. %s (%d)", tosend, i, ws->word, ws->nr);
    ws = ws->next;
  }
  dprintf(DP_HELP, "%s\n", tosend);
  nfree(tosend);
  Context;
}

static int stat_flood()
{
  if (!maxstat_thr || !maxstat_time)
    return 0;
  if ((now - mstat_time) > maxstat_time) {
    mstat_time = now;
    mstat_thr = 0;
  }
  mstat_thr++;
  if (mstat_thr > maxstat_thr)
    return 1;
  return 0;
}

static cmd_t stats_pub[] =
{
  {"!top10", "", pub_top10, 0},
  {"!ttop10", "", pub_ttop10, 0},
  {"!top20", "", pub_top20, 0},
  {"!ttop20", "", pub_ttop20, 0},
  {"!place", "", pub_place, 0},
  {"!tplace", "", pub_tplace, 0},
  {"!stat", "", pub_stat, 0},
  {"!tstat", "", pub_tstat, 0},
  {"!wordstats", "", pub_wordstats, 0},
  {"!topwords", "", pub_topwords, 0},
  {0, 0, 0, 0}
};
