#include <unistd.h>
#include "fmtscan.h"
#include "sgetopt.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "background" ;
#define USAGE "background [ -d ] ~command... ; [ command... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  unsigned char df = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "d")) != opteof)
      switch (opt)
      {
        case 'd' : df = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  {
    char fmt[FMT_ULONG] ;
    int pid ;
    int argc1 = el_semicolon(argv) ;
    if (!argc1) strerr_dief1x(100, "empty block") ;
    if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
    if (argc1 + 1 == argc) df = 0 ;

    pid = df ? doublefork() : fork() ;
    switch (pid)
    {
      case -1: strerr_diefu2sys(111, df ? "double" : "", "fork") ;
      case 0:
        argv[argc1] = 0 ;
        pathexec0_run(argv, envp) ;
        strerr_diewu2sys(111, "spawn ", argv[0]) ;
    }
    if (argc1 + 1 == argc) return 0 ;
    fmt[uint_fmt(fmt, pid)] = 0 ;
    if (!pathexec_env("LASTPID", fmt))
      strerr_diefu1sys(111, "update environment") ;
    pathexec0(argv+argc1+1) ;
    strerr_dieexec(111, argv[argc1+1]) ;
  }
}
