#include <unistd.h>
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "cd" ;
#define USAGE "cd path prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  if (argc < 3) strerr_dieusage(100, USAGE) ;
  if (chdir(argv[1]) == -1)
    strerr_diefu2sys(111, "chdir to ", argv[1]) ;
  pathexec_run(argv[2], argv+2, envp) ;
  strerr_dieexec(111, argv[2]) ;
}
