#include "bytestr.h"
#include "sgetopt.h"
#include "fmtscan.h"
#include "buffer.h"
#include "strerr2.h"
#include "djbunix.h"
#include "netstring.h"

char const *PROG = "dollarat" ;
#define USAGE "dollarat [ -n ] [ -d delimchar ]"

int main (int argc, char const *const *argv, char const *const *envp)
{
  unsigned int n, i = 0 ;
  char const *x ;
  char delim = '\n' ;
  unsigned char nl = 1 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "nd:")) != opteof)
      switch (opt)
      {
        case 'n' : nl = 0 ; break ;
        case 'd' : delim = *optarg ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  x = env_get2(envp, "#") ;
  if (!x) strerr_dienotset(100, "#") ;
  if (!uint0_scan(x, &n))
    strerr_dieinvalid(100, "#") ;

  for (; i < n ; i++)
  {
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, i+1)] = 0 ;
    x = env_get2(envp, fmt) ;
    if (!x) strerr_dienotset(100, fmt) ;
    if (delim)
    {
      if ((buffer_putsalign(buffer_1, x) == -1)
       || (((i < n-1) || nl) && (buffer_PUTC(buffer_1, delim) == -1)))
        goto err ;
    }
    else
    {
      unsigned int written = 0 ;
      if (netstring_put(buffer_1, x, str_len(x), &written) == -1)
        goto err ;
    }
  }

  if (buffer_flush(buffer_1) == -1) goto err ;
  return 0 ;
err:
  strerr_diefu1sys(111, "write to stdout") ;
}
