#include <unistd.h>
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

void el_execsequence (char const *const *argv1, char const *const *argv2)
{
  if (!argv2[0])
  {
    pathexec0(argv1) ;
    strerr_dieexec(111, argv1[0]) ;
  }
  {
    int wstat ;
    char fmt[FMT_ULONG] ;
    int pid = fork() ;
    switch (pid)
    {
      case -1: strerr_diefu1sys(111, "fork") ;
      case 0:
        pathexec0(argv1) ;
        strerr_diewu2sys(111, "spawn ", argv1[0]) ;
    }
    if (wait_pid(&wstat, pid) == -1)
      strerr_diefu2sys(111, "wait for ", argv1[0]) ;
    fmt[uint_fmt(fmt, wait_status(wstat))] = 0 ;
    if (!pathexec_env("LASTEXITCODE", fmt))
      strerr_diefu1sys(111, "update environment") ;
  }
  pathexec(argv2) ;
  strerr_dieexec(111, argv2[0]) ;
}
