#include "env.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "execline.h"

int el_semicolon (register char const **argv)
{
  static unsigned int nblock = 0 ;
  register int argc1 = 0 ;
  nblock++ ;
  for (;; argc1++, argv++)
  {
    register char const *arg = *argv ;
    if (!arg) return argc1 + 1 ;
    if ((arg[0] == ';') && !arg[1]) return argc1 ;
    else if (arg[0] == '~') ++*argv ;
    else
    {
      unsigned int strict = el_getstrict() ;
      if (strict)
      {
        char fmt1[FMT_ULONG] ;
        char fmt2[FMT_ULONG] ;
        fmt1[uint_fmt(fmt1, nblock)] = 0 ;
        fmt2[uint_fmt(fmt2, (unsigned int)argc1)] = 0 ;
        if (strict >= 2)
          strerr_dief6x(100, "unquoted argument ", arg, " at block ", fmt1, " position ", fmt2) ;
        else
          strerr_warnw6x("unquoted argument ", arg, " at block ", fmt1, " position ", fmt2) ;
      }
    }
  }
}
