#include "bytestr.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "execline.h"

typedef struct elsubsu elsubsu, *elsubsu_ref, **elsubsu_ref_ref ;
struct elsubsu
{
  unsigned int pos ;
  elsubst const *subst ;
} ;

GEN_ALLOC_typedef(subsualloc, elsubsu, s, len, a)
static GEN_ALLOC_free(subsualloc, elsubsu, s, len, a)
static inline GEN_ALLOC_ready(subsualloc, elsubsu, s, len, a, 4)
static inline GEN_ALLOC_readyplus(subsualloc, elsubsu, s, len, a)
static inline GEN_ALLOC_catb(subsualloc, elsubsu, s, len, a)


#define TEST 0x80
#define MARK 0x40
#define KEEPESC 0x20
#define INCRESC 0x10

#define STATE 0x07
#define INWORD 0x00
#define INDOLL 0x01
#define INDBR 0x02
#define INVAR 0x03
#define INVARBR 0x04
#define ACCEPT 0x05

static int parseword (stralloc *sa, subsualloc *list, char const *s, elsubst const *substs, unsigned int nsubst)
{
  char const class[5] = "\0\\${}" ;
  unsigned char const table[6][5] =
  {
    { ACCEPT, ACCEPT, ACCEPT, ACCEPT | TEST, ACCEPT },
    { INWORD | KEEPESC | INCRESC, INWORD | INCRESC, INWORD | INCRESC, INWORD | TEST | INCRESC, INWORD | INCRESC },
    { INDOLL | KEEPESC, INDOLL, INDOLL, INDOLL | TEST, INDOLL },
    { INWORD, INDBR | KEEPESC, INWORD, INWORD | TEST, INWORD },
    { INWORD, INWORD, INWORD, INWORD | TEST, INWORD | TEST },
    { INWORD, INVAR | MARK | KEEPESC, INVARBR | MARK | KEEPESC, INVAR | KEEPESC, INVARBR | KEEPESC }
  } ;

  unsigned int mark = 0, pos = 0, offset = 0, esc = 0, salen = sa->len, listlen = list->len ;
  unsigned char state = INWORD ;

  while (state != ACCEPT)
  {
    unsigned char c = table[byte_chr(class, 5, s[pos])][state] ;
    unsigned char nopush = 0 ;

    if (c & TEST)
    {
      unsigned int supp = (state == INVARBR) ;
      unsigned int i = 0 ;
      for ( ; i < nsubst ; i++)
      {
        if (!str_diffn(substs[i].var, s + mark, pos - mark) && !substs[i].var[pos - mark])
        {
          sa->len -= esc >> 1 ; offset += esc >> 1 ;
          if (esc & 1)
          {
            byte_copy(sa->s + mark - offset - 2 - supp, pos - mark + 1 + supp, sa->s + mark - offset + (esc>>1) - 1 - supp) ;
            sa->len-- ; offset++ ;
          }
          else
          {
            elsubsu cur ;
            cur.pos = mark - offset - 1 - supp ;
            cur.subst = substs + i ;
            if (!subsualloc_catb(list, &cur, 1)) goto err ;
            offset += sa->len - cur.pos ;
            sa->len = cur.pos ;
            if (supp) nopush = 1 ;
          }
          break ;
        }
      }
    }
    if (nopush) offset++ ;
    else if (!stralloc_catb(sa, s+pos, 1)) goto err ;
    if (c & MARK) mark = pos ;
    if (!(c & KEEPESC)) esc = 0 ;
    if (c & INCRESC) esc++ ;
    state = c & STATE ; pos++ ;
  }
  sa->len-- ;
  return (int)pos ;

err:
  sa->len = salen ;
  list->len = listlen ;
  return -1 ;
}

static int substword (stralloc *dst, stralloc *sa, unsigned int wordstart, unsigned int wordlen, elsubsu const *list, unsigned int n, unsigned int offset)
{
  unsigned int dstlen = dst->len ;
  if (n)
  {
    unsigned int i = 0, l = list[0].pos + offset, origlen = sa->len ;
    int nc = 0 ;
    char const *p = list[0].subst->value ;
    if (!stralloc_readyplus(sa, l)) return -1 ;
    stralloc_catb(sa, sa->s + wordstart, l) ;
    for ( ; i < list[0].subst->n ; i++)
    {
      int r ;
      unsigned int plen = str_len(p) ;
      sa->len = origlen + l ;
      if (!stralloc_readyplus(sa, plen + wordlen - l))
      {
        sa->len = origlen ;
        goto err ;
      }
      stralloc_catb(sa, p, plen) ;
      stralloc_catb(sa, sa->s + wordstart + l, wordlen - l) ;
      r = substword(dst, sa, origlen, sa->len - origlen, list+1, n-1, offset + plen) ;
      if (r < 0)
      {
        sa->len = origlen ;
        goto err ;
      }
      nc += r ;
      p += plen+1 ;
    }
    return nc ;
  }
  else
  {
    if (!stralloc_catb(dst, sa->s + wordstart, wordlen)) return -1 ;
    if (!stralloc_0(dst)) goto err ;
    return 1 ;
  }
err:
  dst->len = dstlen ;
  return -1 ;
}

int el_substitute (stralloc *dst, char const *src, unsigned int len, elsubst const *substs, unsigned int nsubst)
{
  stralloc word = GEN_ALLOC_ZERO ;
  subsualloc list = GEN_ALLOC_ZERO ;
  unsigned int nc = 0, i = 0, dstlen = dst->len ;
  unsigned char wasnull = !dst->s ;
  while (i < len)
  {
    int r ;
    word.len = list.len = 0 ;
    r = parseword(&word, &list, src + i, substs, nsubst) ;
    if (r < 0) goto err ;
    i += r ;
    r = substword(dst, &word, 0, word.len, list.s, list.len, 0) ;
    if (r < 0) goto err ;
    nc += r ;
  }
  subsualloc_free(&list) ;
  stralloc_free(&word) ;
  return (int)nc ;

err :
  subsualloc_free(&list) ;
  stralloc_free(&word) ;
  if (wasnull) stralloc_free(dst) ;
  else dst->len = dstlen ;
  return -1 ;
}
