#include "bytestr.h"
#include "sgetopt.h"
#include "fmtscan.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "elgetopt" ;
#define USAGE "elgetopt optstring prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  unsigned int n, nbak ;
  unsigned int i = 0, envlen = env_len(envp) ;
  envalloc v = GEN_ALLOC_ZERO ;
  stralloc modif = GEN_ALLOC_ZERO ;
  char const **args ;
  char const *x = env_get2(envp, "#") ;
  if (argc < 3) strerr_dieusage(100, USAGE) ;
  if (!x) strerr_dienotset(100, "#") ;
  if (!uint0_scan(x, &n)) strerr_dieinvalid(100, "#") ;
  nbak = n++ ;
  if (!envalloc_ready(&v, n+1)) goto err ;
  args = v.s ;
  for ( ; i < n ; i++)
  {
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, i)] = 0 ;
    if (!(args[i] = env_get2(envp, fmt)))
      strerr_dienotset(100, fmt) ;
  }
  args[n] = 0 ;
  {
    register int opt ;
    while ((opt = sgetopt(n, args, argv[1])) != opteof)
    {
      char hmpf[11] = "ELGETOPT_?" ;
      if (opt == '?') return 1 ;
      hmpf[9] = opt ;
      if (!env_addmodif(&modif, hmpf, optarg ? optarg : "1")) goto err ;
    }
    n -= optind ;
    args += optind ;
  }
  for (i = 0 ; i < nbak ; i++)
  {
    char fmt[FMT_ULONG]  ;
    fmt[uint_fmt(fmt, i+1)] = 0 ;
    if (!env_addmodif(&modif, fmt, (i < n) ? args[i] : 0)) goto err ;
  }
  {
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, n)] = 0 ;
    if (!env_addmodif(&modif, "#", fmt)) goto err ;
  }
  {
    stralloc tmp = GEN_ALLOC_ZERO ;
    char const *const list[1] = { "ELGETOPT_" } ;
    if (el_pushenv(&tmp, envp, envlen, list, 1) < 0) goto err ;
    if (!envalloc_make(&v, envlen, tmp.s, tmp.len)) goto err ;
    pathexec_r(argv+2, v.s, v.len, modif.s, modif.len) ;
    strerr_dieexec(111, argv[2]) ;
  }
err:
  strerr_diefu1sys(111, "update environment") ;
}
