#include "bytestr.h"
#include "fmtscan.h"
#include "sgetopt.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "djbunix.h"
#include "uintalloc.h"
#include "execline.h"
#include "exlp.h"

char const *PROG = "elgetpositionals" ;
#define USAGE "elgetpositionals [ -P num ] prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  stralloc vars = GEN_ALLOC_ZERO ;
  stralloc values = GEN_ALLOC_ZERO ;
  uintalloc offsets = GEN_ALLOC_ZERO ;
  substalloc big = GEN_ALLOC_ZERO ;
  unsigned int n, ntot, nmin = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "P:")) != opteof)
      switch (opt)
      {
        case 'P' : if (uint0_scan(optarg, &nmin)) break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if (!argc) strerr_dieusage(100, USAGE) ;

  n = exlp(nmin, envp, &vars, &values, &offsets) ;
  ntot = n > nmin ? n : nmin ;
  if (!substalloc_ready(&big, ntot+3)) goto err ;
  {
    register unsigned int i = 0 ;
    for ( ; i < ntot+2 ; i++) big.s[big.len++].n = 1 ;
  }
  big.s[big.len++].n = n ;
  el_updatesubsts(big.s, big.len, vars.s, values.s, offsets.s) ;
  uintalloc_free(&offsets) ;

  {
    envalloc v = GEN_ALLOC_ZERO ;
    stralloc src = GEN_ALLOC_ZERO ;
    stralloc dst = GEN_ALLOC_ZERO ;
    int nc ;
    if (!env_string(&src, argv, (unsigned int)argc)) goto err ;
    nc = el_substitute(&dst, src.s, src.len, big.s, big.len) ;
    stralloc_free(&src) ;
    substalloc_free(&big) ;
    stralloc_free(&values) ;
    stralloc_free(&vars) ;
    if (nc < 0) goto err ;
    if (!envalloc_make(&v, (unsigned int)nc, dst.s, dst.len)
     || !envalloc_0(&v)) goto err ;
    pathexec_run(v.s[0], v.s, envp) ;
    strerr_dieexec(111, v.s[0]) ;
  }

err:
  strerr_diefu1sys(111, "get positional parameters") ;
}
