#include "uint16.h"
#include "sgetopt.h"
#include "bytestr.h"
#include "fmtscan.h"
#include "buffer.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "envalloc.h"
#include "uintalloc.h"
#include "djbunix.h"
#include "execline.h"
#include "exlp.h"

#ifdef EXECLINEB
# define BCHAR "b"
#else
# define BCHAR ""
#endif

char const *PROG = "execline" BCHAR ;
#define USAGE "execline" BCHAR " [ -p | -P | -S nmin ] [ -q | -w | -W ] [ -c commandline ] script args"

typedef unsigned char chargen_t (void) ;

/* Action (strongest 11 bits) */

#define PUSH 0x8000
#define PUSH0 0x4000
#define PUSHSPECIAL 0x2000
#define SETBASE 0x1000
#define MARK 0x0800
#define CALC 0x0400
#ifdef EXECLINEB
# define QUOTE 0x0200
# define INCB 0x0100
# define DECB 0x0080
#endif


/* State (weakest 5 bits) */

#define MAIN 0x00
#define INWORD 0x01
#define INWORDESC 0x02
#define INSTR 0x03
#define INSTRESC 0x04
#define INREM 0x05
#define OCT0 0x06
#define OCT1 0x07
#define OCT2 0x08
#define DEC1 0x09
#define DEC2 0x0a
#define HEX0 0x0b
#define HEX1 0x0c
#define ENDCALC 0x0d
#ifdef EXECLINEB
# define OPENB 0x0e
# define CLOSEB 0x0f
#endif
#define ERROR 0x10
#define ACCEPT 0x11

#ifdef EXECLINEB
# define NCLASS 16
# define OPENBCLASS "n"
# define CLOSEBCLASS "o"
#else
# define NCLASS 14
# define OPENBCLASS "f"
# define CLOSEBCLASS "f"
#endif

static buffer b ;

static void initbuffer (char const *s)
{
  static char buf[BUFFER_INSIZE] ;
  int fd = open_readb(s) ;
  if (fd == -1) strerr_diefu3sys(111, "open ", s, " for reading") ;
  if (coe(fd) == -1) strerr_diefu2sys(111, "coe ", s) ;
  buffer_init(&b, &buffer_unixread, fd, buf, BUFFER_INSIZE) ;
}

static unsigned char nextinbuffer ()
{
  char c ;
  switch (buffer_GETC(&b, &c))
  {
    case -1: strerr_diefu1sys(111, "read script") ;
    case 0 : return 0 ;
  }
  return (unsigned char)c ;
}

static unsigned char const *string = 0 ;

static unsigned char nextinstring ()
{
  static unsigned int pos = 0 ;
  return string[pos++] ;
}

static int lex (stralloc *sa, chargen_t next)
{
  unsigned char const class[256] = "`aaaaaaaaadaaaaaaaaaaaaaaaaaaaaaafcbffffffffffffjhhhhhhhiifffffffmmmmmmfffffffffffffffffffffeffffggmmmgfffffffkfffkfkfkflff" OPENBCLASS "f" CLOSEBCLASS "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff" ;
  uint16 const table[NCLASS][16] =
  {
    { 0x0011, 0x4011, 0x0010, 0x0010, 0x0010, 0x0011, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x4091 },
    { 0x0000, 0x4000, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x0100, 0x4080 },
    { 0x0005, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 },
    { 0x0203, 0x0003, 0x8001, 0x0001, 0x8003, 0x0005, 0x0010, 0x0401, 0x0401, 0x0401, 0x0401, 0x0010, 0x0401, 0x0401, 0x0003, 0x0003 },
    { 0x0000, 0x4000, 0x8001, 0x8003, 0x0003, 0x0000, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x0100, 0x4080 },
    { 0x0202, 0x0002, 0x8001, 0x0004, 0x8003, 0x0005, 0x0010, 0x0404, 0x0404, 0x0404, 0x0404, 0x0010, 0x0404, 0x0404, 0x0002, 0x0002 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x2003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x880c, 0x800d, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x9809, 0x0005, 0x8807, 0x8008, 0x800d, 0x800a, 0x800d, 0x880c, 0x800d, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x9809, 0x0005, 0x0010, 0x8403, 0x8403, 0x800a, 0x800d, 0x880c, 0x800d, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x1006, 0x0005, 0x8807, 0x8008, 0x800d, 0x800a, 0x800d, 0x880c, 0x800d, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x2003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x100b, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 },
    { 0x8201, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x880c, 0x800d, 0x8403, 0x8001, 0x8001 }
#ifdef EXECLINEB
   ,{ 0x820e, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 }
   ,{ 0x820f, 0x8001, 0x8001, 0x8003, 0x8003, 0x0005, 0x0010, 0x8403, 0x8403, 0x8403, 0x8403, 0x0010, 0x8403, 0x8403, 0x8001, 0x8001 }
#endif
  } ;

  unsigned int mark = 0 ;
  int n = 0 ;
  unsigned char state = MAIN, base = 10 ;
#ifdef EXECLINEB
  unsigned int blevel = 0 ;
#endif

  while (state < ERROR)
  {
    unsigned char cur = next() ;
    register uint16 c = table[class[cur]-'`'][state] ;
    state = c & 0x1F ;

 /* Actions. The order is important ! */

    if (c & CALC)
    {
      unsigned int result ;
      if (!stralloc_0(sa)) return -1 ;
      sa->len = mark ;
      switch (base)
      {
        case 16: scan_xint(sa->s + sa->len, &result) ; break ;
        case 8: scan_oint(sa->s + sa->len, &result) ; break ;
        case 10: scan_uint(sa->s + sa->len, &result) ; break ;
      }
      sa->s[sa->len++] = (unsigned char)result ;
    }
    if (c & MARK) mark = sa->len ;
#ifdef EXECLINEB
    if (c & QUOTE)
    {
      register unsigned int i = blevel ;
      while (i--) if (!stralloc_catb(sa, "~", 1)) return -1 ;
    }
    if (c & INCB) sa->len -= ++blevel ;
    if (c & DECB) { if (!blevel--) return -4 ; sa->s[--sa->len-1] = ';' ; }
#endif
    if (c & PUSH) if (!stralloc_catb(sa, &cur, 1)) return -1 ;
    if (c & PUSHSPECIAL)
    {
      char x = 7 + byte_chr("abtnvfr", 7, cur) ;
      if (!stralloc_catb(sa, &x, 1)) return -1 ;
    }
    if (c & PUSH0) if (n++, !stralloc_0(sa)) return -1 ;
    if (c & SETBASE)
      switch (cur)
      {
        case 'x' : base = 16 ; break ;
        case '0' : base = 8 ; break ;
        default : base = 10 ;
      }
  }
  if (state == ERROR) return -2 ;
#ifdef EXECLINEB
  if (blevel) return -3 ;
#endif
  return n ;
}


static int exl_subst_pos (stralloc *sa, char const *const *argv, unsigned int argc, unsigned int nmin, char const *dollar0)
{
  stralloc dst = GEN_ALLOC_ZERO ;
  stralloc vars = GEN_ALLOC_ZERO ;
  stralloc values = GEN_ALLOC_ZERO ;
  substalloc big = GEN_ALLOC_ZERO ;
  uintalloc offsets = GEN_ALLOC_ZERO ;
  char fmt[ULONG_FMT] ;
  unsigned int n = argc > nmin ? argc : nmin ;
  unsigned int i = 0 ;

  if (!substalloc_ready(&big, 3 + n)) return -1 ;
  if (!uintalloc_ready(&offsets, n))
  {
    substalloc_free(&big) ;
    return -1 ;
  }
  if (!env_string(&values, argv, argc))
  {
    uintalloc_free(&offsets) ;
    substalloc_free(&big) ;
    return -1 ;
  }
  offsets.len = n ;
  for (; i < n ; i++)
  {
    offsets.s[i] = vars.len ;
    if (!stralloc_catb(&vars, fmt, uint_fmt(fmt, i+1)) || !stralloc_0(&vars))
    {
      stralloc_free(&vars) ;
      stralloc_free(&values) ;
      uintalloc_free(&offsets) ;
      substalloc_free(&big) ;
      return -1 ;
    }
  }
  big.len = 3 + n ;
  big.s[0].var = "#" ;
  fmt[uint_fmt(fmt, argc)] = 0 ;
  big.s[0].value = fmt ;
  big.s[0].n = 1 ;
  big.s[1].var = "@" ;
  big.s[1].value = values.s ;
  big.s[1].n = argc ;
  big.s[2].var = "0" ;
  big.s[2].value = dollar0 ;
  big.s[2].n = 1 ;
  for (i = 0 ; i < n ; i++)
  {
    big.s[3+i].var = vars.s + offsets.s[i] ;
    big.s[3+i].value = (i < argc) ? argv[i] : "" ;
    big.s[3+i].n = 1 ;
  }
  uintalloc_free(&offsets) ;

  {
    int nc = el_substitute(&dst, sa->s, sa->len, big.s, big.len) ;
    stralloc_free(&vars) ;
    stralloc_free(&values) ;
    substalloc_free(&big) ;
    stralloc_free(sa) ;
    *sa = dst ;
    return nc ;
  }
}


int main (int argc, char const *const *argv, char const *const *envp)
{
  chargen_t *next ;
  stralloc sa = GEN_ALLOC_ZERO ;
  stralloc modif = GEN_ALLOC_ZERO ;
  envalloc v = GEN_ALLOC_ZERO ;
  int nc ;
  int flagstrict = -1 ;
  unsigned int nmin = 0 ;
  char const *dollar0 = argv[0] ;
  unsigned char flagpushenv = 2 ;

  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "pPqwWc:S:")) != opteof)
      switch (opt)
      {
        case 'p' : flagpushenv = 1 ; break ;
        case 'P' : flagpushenv = 0 ; break ;
        case 'q' : flagstrict = 0 ; break ;
        case 'w' : flagstrict = 1 ; break ;
        case 'W' : flagstrict = 2 ; break ;
        case 'c' : string = optarg ; break ;
        case 'S' :
        {
          if (!uint0_scan(optarg, &nmin)) strerr_dieusage(100, USAGE) ;
          flagpushenv = 3 ;
          break ;
        }
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
    if (string) next = &nextinstring ;
    else
    {
      if (!argv[0]) strerr_dieusage(100, USAGE) ;
      initbuffer(argv[0]) ;
      dollar0 = argv[0] ;
      argv++ ; argc-- ;
      next = &nextinbuffer ;
    }
  }

  nc = lex(&sa, *next) ;
  switch (nc)
  {
#ifdef EXECLINEB
    case -4: strerr_dief2x(100, "unmatched ", "}") ;
    case -3: strerr_dief2x(100, "unmatched ", "{") ;
#endif
    case -2: strerr_dief1x(100, "syntax error") ;
    case -1: strerr_diefu1sys(111, "parse script") ;
    case 0 : return 0 ;
  }

  if (flagstrict >= 0)
  {
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, (unsigned int)flagstrict)] = 0 ;
    if (!env_addmodif(&modif, "EXECLINE_STRICT", flagstrict ? fmt : 0)) goto errenv ;
  }

  if (flagpushenv == 3)
  {
    flagpushenv = 0 ;
    nc = exl_subst_pos(&sa, argv, (unsigned int)argc, nmin, dollar0) ;
    if (nc < 0) strerr_diefu1sys(111, "substitute positional parameters") ;
  }
  else if (flagpushenv)
  {
    char fmt[FMT_ULONG] ;
    register unsigned int i = 0 ;
    fmt[uint_fmt(fmt, argc)] = 0 ;
    if (!env_addmodif(&modif, "#", fmt)) goto errenv ;
    if (!env_addmodif(&modif, "0", dollar0)) goto errenv ;
    for (; i < (unsigned int)argc ; i++)
    {
      fmt[uint_fmt(fmt, i+1)] = 0 ;
      if (!env_addmodif(&modif, fmt, argv[i])) goto errenv ;
    }
  }

  if (!envalloc_make(&v, (unsigned int)nc, sa.s, sa.len) || !envalloc_0(&v))
    strerr_diefu1sys(111, "make argv") ;

  if (flagpushenv > 1)
  {
    char const *const list[11] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "#" } ;
    stralloc sb = GEN_ALLOC_ZERO ;
    envalloc w = GEN_ALLOC_ZERO ;
    unsigned int envlen = env_len(envp) ;
    if ((el_pushenv(&sb, envp, envlen, list, 11) < 0)
     || !envalloc_make(&w, envlen, sb.s, sb.len))
    goto errenv ;
    pathexec_r(v.s, w.s, w.len, modif.s, modif.len) ;
    envalloc_free(&w) ;
    stralloc_free(&sb) ;
  }
  else if (modif.len)
    pathexec_r(v.s, envp, env_len(envp), modif.s, modif.len) ;
  else
    pathexec_run(v.s[0], v.s, envp) ;

  stralloc_free(&modif) ;
  strerr_dieexec(111, v.s[0]) ;

errenv:
  strerr_diefu1sys(111, "update environment") ;  
}
