#ifndef EXECLINE_H
#define EXECLINE_H

#include "gccattributes.h"
#include "stralloc.h"
#include "envalloc.h"


/* Basics */

extern int el_vardupl (char const *, char const *, unsigned int) gccattr_pure ;


/* Environment shifting */

extern int el_pushenv (stralloc *, char const *const *, unsigned int, char const *const *, unsigned int) ;
extern int el_popenv  (stralloc *, char const *const *, unsigned int, char const *const *, unsigned int) ;


/* Sequence */

extern void el_execsequence (char const *const *, char const *const *) gccattr_noreturn ;


/* Block unquoting */

extern unsigned int el_getstrict (void) gccattr_const ;
extern int el_semicolon (char const **) ;


/* Value transformation */

typedef struct eltransforminfo eltransforminfo, *eltransforminfo_ref ;
struct eltransforminfo
{
  char const *delim ;
  unsigned char crunch : 1 ;
  unsigned char chomp : 1 ;
  unsigned char split : 1 ;
} ;

#define ELTRANSFORMINFO_ZERO { " \n\r\t", 0, 0, 0 }

extern int el_transform (stralloc *, unsigned int, eltransforminfo const *) ;


/* Substitution */

typedef struct elsubst elsubst, *elsubst_ref ;
struct elsubst
{
  char const *var ;
  char const *value ;
  unsigned int n ;
} ;

extern void el_updatesubsts (elsubst *, unsigned int, char const *, char const *, unsigned int *) ;
extern int el_substitute (stralloc *, char const *, unsigned int, elsubst const *, unsigned int) ;

#endif
