#include "bytestr.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "djbunix.h"
#include "uintalloc.h"
#include "execline.h"
#include "exlp.h"

static void die()
{
  strerr_diefu1sys(111, "read positionals") ;
}

unsigned int exlp (unsigned int nmin, char const *const *envp, stralloc *vars, stralloc *values, uintalloc *offsets)
{
  char const *x = env_get2(envp, "#") ;
  unsigned int n, ntot, poszero, i = 0 ;
  if (!x) strerr_dienotset(100, "#") ;
  if (!uint0_scan(x, &n)) strerr_dieinvalid(100, "#") ;
  if (el_vardupl("#", vars->s, vars->len))
    strerr_dief3x(100, "variable ", "#", " appears more than once") ;
  if (el_vardupl("@", vars->s, vars->len))
    strerr_dief3x(100, "variable ", "@", " appears more than once") ;
  if (!uintalloc_catb(offsets, &vars->len, 1)
   || !uintalloc_catb(offsets, &values->len, 1)
   || !stralloc_catb(vars, "#", 2)
   || !stralloc_cats(values, x)
   || !stralloc_0(values)) die() ;
  ntot = n > nmin ? n : nmin ;
  poszero = values->len ;
  for ( ; i < ntot+1 ; i++)
  {
    char fmt[FMT_ULONG] ;
    unsigned int l = uint_fmt(fmt, i) ;
    fmt[l] = 0 ;
    if (el_vardupl(fmt, vars->s, vars->len))
      strerr_dief3x(100, "variable ", fmt, " appears more than once") ;
    x = (i <= n) ? env_get2(envp, fmt) : "" ;
    if (!x) strerr_dienotset(100, fmt) ;
    if (!uintalloc_catb(offsets, &vars->len, 1)
     || !uintalloc_catb(offsets, &values->len, 1)
     || !stralloc_catb(vars, fmt, l+1)
     || !stralloc_cats(values, x)
     || !stralloc_0(values)) die() ;
  }
  if (!uintalloc_catb(offsets, &vars->len, 1)
   || !stralloc_catb(vars, "@", 2)) die() ;
  i = poszero + str_len(values->s + poszero) + 1 ;
  if (!uintalloc_catb(offsets, &i, 1)) die() ;
  return n ;
}
