#include <unistd.h>
#include "bytestr.h"
#include "sgetopt.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"
#include "exls1.h"

int exls1_backtick (int argc, char const **argv, char const *const *envp, exls1info_ref blah)
{
  int argc1 ;
  unsigned int offset = blah->value.len ;
  unsigned int n ;
  eltransforminfo si = ELTRANSFORMINFO_ZERO ;
  {
    register int opt ;
    optind = 1 ;
    while ((opt = subgetopt(argc, argv, "nsCcd:")) != opteof)
      switch (opt)
      {
        case 'n' : si.chomp = 1 ; break ;
        case 's' : si.split = 1 ; break ;
        case 'C' : si.crunch = 1 ; break ;
        case 'c' : si.crunch = 0 ; break ;
        case 'd' : si.delim = optarg ; break ;
        default : return -3 ;
      }
    argc -= optind ;
    argv += optind ;
    n = optind ;
  }

  if (!argc--) return -3 ;
  argc1 = el_semicolon(++argv) ;
  if (argc1 >= argc) return -3 ;
  n += argc1 + 2 ;
  {
    int fd[2] ;
    int pid ;
    if (pipe(fd) == -1) return -1 ;
    switch ((pid = fork()))
    {
      case -1:
        fd_close(fd[1]) ;
        fd_close(fd[0]) ;
        return -1 ;
      case 0:
        argv[argc1] = 0 ;
        fd_close(fd[0]) ;
        if (fd_move(1, fd[1]) == -1)
          strerr_diewu1sys(111, "move backtick's writer fd") ;
        pathexec0_run(argv, envp) ;
        strerr_diewu2sys(111, "spawn backtick's ", argv[0]) ;
    }
    fd_close(fd[1]) ;
    if (!slurp(&blah->value, fd[0]))
    {
      fd_close(fd[0]) ;
      return -1 ;
    }
    fd_close(fd[0]) ;
    if (wait_pid(&fd[0], pid) == -1)
    {
      blah->value.len = offset ;
      return -1 ;
    }
  }
  {
    register int r = el_transform(&blah->value, offset, &si) ;
    if (r < 0)
    {
      blah->value.len = offset ;
      return r ;
    }
    blah->n = r ;
  }
  blah->var = argv[-1] ;
  return n ;
}
