#include <errno.h>
#include "shglob.h"
#include "sgetopt.h"
#include "strerr2.h"
#include "stralloc.h"
#include "exls1.h"

static int elgloberrfunc (char const *s, int e)
{
  errno = e ;
  strerr_warnw2sys("while globbing, error reading ", s) ;
  return 0 ;
}

int exls1_elglob (int argc, char const **argv, char const *const *envp, exls1info_ref blah)
{
  unsigned int offset = blah->value.len ;
  unsigned int n ;
  int flags = GLOB_NOSORT | GLOB_NOCHECK ;
  unsigned char verbose = 0 ;
  {
    register int opt ;
    optind = 1 ;
    while ((opt = subgetopt(argc, argv, "vwsme0")) != opteof)
      switch (opt)
      {
	case 'v' : verbose = 1 ; break ;
        case 'w' : flags |= GLOB_ERR ; break ;
        case 's' : flags &= ~GLOB_NOSORT ; break ;
        case 'm' : flags |= GLOB_MARK ; break ;
        case 'e' : flags |= GLOB_NOESCAPE ; break ;
        case '0' : flags &= ~GLOB_NOCHECK ; break ;
        default : return -3 ;
      }
    argc -= optind ;
    argv += optind ;
    n = optind ;
  }
  if (argc < 2) return -3 ;
  {
    unsigned int i = 0 ;
    glob_t pglob ;
    pglob.gl_offs = 0 ;
    switch (shglob(argv[1], flags, verbose ? &elgloberrfunc : 0, &pglob))
    {
      case 0 : break ;
      case GLOB_NOMATCH:
      {
        pglob.gl_pathc = 0 ;
        pglob.gl_pathv = 0 ;
        break ;
      }
      default: return -1 ;
    }
    for ( ; i < (unsigned int)pglob.gl_pathc ; i++)
      if (!stralloc_cats(&blah->value, pglob.gl_pathv[i])
       || !stralloc_0(&blah->value))
      {
        globfree(&pglob) ;
        blah->value.len = offset ;
        return -1 ;
      }
    blah->n = pglob.gl_pathc ;
    globfree(&pglob) ;
  }
  blah->var = argv[0] ;
  (void)envp ;
  return (int)n + 2 ;
}
