#include "sgetopt.h"
#include "stralloc.h"
#include "env.h"
#include "execline.h"
#include "exls1.h"

static int exls1_import_as (int argc, char const **argv, char const *const *envp, exls1info_ref blah, unsigned int as)
{
  eltransforminfo si = ELTRANSFORMINFO_ZERO ;
  unsigned int offset = blah->value.len ;
  unsigned int n ;
  char const *defaultval = 0 ;
  char const *x ;
  {
    register int opt ;
    optind = 1 ;
    while ((opt = subgetopt(argc, argv, "D:nsCcd:")) != opteof)
      switch (opt)
      {
        case 'D' : defaultval = optarg ; break ;
        case 'n' : si.chomp = 1 ; break ;
        case 's' : si.split = 1 ; break ;
        case 'C' : si.crunch = 1 ; break ;
        case 'c' : si.crunch = 0 ; break ;
        case 'd' : si.delim = optarg ; break ;
        default : return -3 ;
      }
    argc -= optind ;
    argv += optind ;
    n = optind ;
  }
  if ((unsigned int)argc < 1+as) return -3 ;
  x = env_get2(envp, argv[as]) ;
  if (!x) x = defaultval ;
  if (!x) blah->n = 0 ;
  else
  {
    register int r ;
    if (!stralloc_cats(&blah->value, x)) return -1 ;
    r = el_transform(&blah->value, offset, &si) ;
    if (r < 0)
    {
      blah->value.len = offset ;
      return r ;
    }
    blah->n = r ;
  }
  blah->var = argv[0] ;
  return n + 1 + as ;
}

int exls1_import (int argc, char const **argv, char const *const *envp, exls1info_ref blah)
{
  return exls1_import_as(argc, argv, envp, blah, 0) ;
}

int exls1_importas (int argc, char const **argv, char const *const *envp, exls1info_ref blah)
{
  return exls1_import_as(argc, argv, envp, blah, 1) ;
}
