#include <errno.h>
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "djbunix.h"
#include "execline.h"
#include "exls1.h"

int exls1_doit (int argc, char const **argv, char const *const *envp, exls1_t *func)
{
  stralloc dst = GEN_ALLOC_ZERO ;
  exls1info si = EXLS1INFO_ZERO ;
  int n = (*func)(argc, argv, envp, &si) ;
  if (n < 0) return n ;
  if (!*si.var) return (errno = EINVAL, -1) ;
  {
    elsubst blah = { si.var, si.value.s, si.n } ;
    stralloc src = GEN_ALLOC_ZERO ;
    if (!env_string(&src, argv + n, argc - n))
    {
      stralloc_free(&si.value) ;
      return -1 ;
    }
    n = el_substitute(&dst, src.s, src.len, &blah, 1) ;
    stralloc_free(&src) ;
  }
  stralloc_free(&si.value) ;
  if (n < 0)
  {
    stralloc_free(&dst) ;
    return n ;
  }
  {
    envalloc v = GEN_ALLOC_ZERO ;
    if (!envalloc_make(&v, (unsigned int)n, dst.s, dst.len)
     || !envalloc_0(&v))
    {
      stralloc_free(&dst) ;
      return -1 ;
    }
    pathexec0_run(v.s, envp) ;
    strerr_dieexec(111, v.s[0]) ;
  }
}

void exls1_main (int argc, char const **argv, char const *const *envp, exls1_t *func, char const *USAGE)
{
  switch (exls1_doit(argc, argv, envp, func))
  {
    case -3 : strerr_dieusage(100, USAGE) ;
    case -2 :
    case -1 :
      strerr_diefu1sys(111, "perform substitution") ;
  }
  strerr_diefu1x(111, "perform substitution") ;
}
